% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/runTestDir.R
\name{getFormattedStacktrace}
\alias{getFormattedStacktrace}
\title{Get formatted stack trace for an uncaught error from a tinytest test file.}
\usage{
getFormattedStacktrace()
}
\value{
\code{character(1)} a single length character string suitable to be printed to the end-user.
In case of no stakctrace (eg the error occured at root level of the script) NA_character_
is returned!
}
\description{
getFormattedStacktrace is a helper function that formats stacktrace for uncaught errors from a
tinytest run file.
}
\details{
This function assumes that it directly called from a withCallingHandler
error handling function! This fact is then used to remove the calling handler info from the
stack such that stack directly starts from where the error was thrown.

The function also removes the calls from the stack that involve
executing the \code{test_file}. The internals of runTestDir and tinytest are not of intererst.
And the highest level of the stack to consider is the top level of the test_file.

Note, this does mean that errors that occur on the top-level of the test file will not have a
a stacktrace!
For example: "Error: object 'x' not found" where x is attempted to be resolved
at the root levels
}
