% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metal_edta.R
\name{metal_edta}
\alias{metal_edta}
\title{Complexation Titration Curve}
\usage{
metal_edta(conc.metal = 0.1, conc.edta = 0.1, vol.metal = 50, ph = 10,
  logkf = 8.79, alpha.metal = 1, plot = TRUE, eqpt = TRUE,
  overlay = FALSE, ...)
}
\arguments{
\item{conc.metal}{Molar concentration of the metal ion analyte;
defaults to 0.10 M.}

\item{conc.edta}{Molar concentration of the EDTA titrant;
defaults to 0.10 M.}

\item{vol.metal}{Initial volume, in mL, of the solution that contains 
the metal ion analyte; defaults to 50.00 mL.}

\item{ph}{The pH of the solution, which is used to calculate the
fraction of EDTA present in its fully deprotonated form; defaults to
a pH of 10.}

\item{logkf}{The log of the formation constant, Kf, for the metal-EDTA
complex; defaults to 8.79, which is the value for the complex of
Mg2+ and EDTA.}

\item{alpha.metal}{The fraction of the metal ion analyte that is not
complexed by an auxilary complexing agent; defaults to 1, the value
when there is no secondary complexing agent present.}

\item{plot}{Logical; if TRUE, plots the titration curve.}

\item{eqpt}{Logical; if TRUE, draws a vertical line at the titration
curve's equivalence point.}

\item{overlay}{Logical; if TRUE, adds the current titration curve
to the existing titration curve.}

\item{\dots}{Additional arguments to pass to \code{plot()} function.}
}
\value{
A two-column data frame that contains the volume of titrant
in the first column and the solution's pMetal in the second column. 
Also produces a plot of the titration curve with options to display 
the equivalence point and to overlay titration curves.
}
\description{
This function calculates and plots the titration curve for a 
metal ion analyte using EDTA as the titrant. The calculation uses 
a single master equation that finds the volume of titrant needed to 
achieve a fixed concentration of the metal ion, pM, as outlined in 
R. de Levie's \emph{Principles of Quantitative Chemical Analysis} 
(McGraw-Hill, 1997).
}
\examples{
### Simple titration curve with equivalence point
ex11 = metal_edta(eqpt = TRUE)
head(ex11)

### Overlay titration curves using different pH values
metal_edta(ph = 12, eqpt = TRUE)
metal_edta(ph = 10, overlay = TRUE)
metal_edta(ph = 8, overlay = TRUE)
}
\author{
David T. Harvey, DePauw University. \email{harvey@depauw.edu}
}

