% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sb_sa.R
\name{sb_sa}
\alias{sb_sa}
\title{Titration Curve for a Strong Base}
\usage{
sb_sa(conc.base = 0.1, conc.acid = 0.1, pkw = 14, vol.base = 50,
  plot = TRUE, overlay = FALSE, eqpt = FALSE, ...)
}
\arguments{
\item{conc.base}{Molar concentration of the strong base analyte;
defaults to 0.10 M.}

\item{conc.acid}{Molar concentration of the strong acid titrant;
defaults to 0.10 M.}

\item{pkw}{The pKw (or pKs) value for the solvent; defaults to water
as a solvent with a pKw of 14.}

\item{vol.base}{Initial volume, in mL, of the solution that 
contains the strong base analyte; defaults to 50.00 mL.}

\item{plot}{Logical; if TRUE, plots the titration curve.}

\item{overlay}{Logical; if TRUE, adds the current titration curve
to the existing titration curve.}

\item{eqpt}{Logical; if TRUE, draws a vertical line at the titration
curve's equivalence point.}

\item{\dots}{Additional arguments to pass to \code{plot()} function.}
}
\value{
A two-column data frame that contains the volume of titrant
in the first column and the solution's pH in the second column. Also
produces a plot of the titration curve with options to display the
equivalence point and to overlay titration curves.
}
\description{
This function calculates and plots the titration curve for a 
monoprotic strong base analyte using a monoprotic strong acid as 
the titrant. The calculation uses a single master equation
that finds the volume of titrant needed to achieve a fixed pH, 
as outlined in R. de Levie's \emph{Principles of Quantitative 
Chemical Analysis} (McGraw-Hill, 1997).
}
\examples{
### Simple titration curve with equivalence point
ex2 = sb_sa(eqpt = TRUE)
head(ex2)

### Overlay titration curves
sb_sa(conc.acid = 0.10)
sb_sa(conc.acid = 0.15, overlay = TRUE)
sb_sa(conc.acid = 0.20, overlay = TRUE)
}
\author{
David T. Harvey, DePauw University. \email{harvey@depauw.edu}
}

