% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/01_class_01_kRp.corpus.R
\docType{class}
\name{kRp.corpus,-class}
\alias{kRp.corpus,-class}
\alias{kRp.corpus}
\alias{kRp.corpus-class}
\title{S4 Class kRp.corpus}
\description{
Objects of this class can contain full text corpora in a hierachical structure. It supports both the \code{tm} package's
\code{\link[tm]{Corpus}} class and \code{koRpus}' own object classes and stores them in separated slots.
}
\details{
Objects should be created using the \code{\link[tm.plugin.koRpus:readCorpus]{readCorpus}} function.
}
\section{Slots}{

\describe{
\item{\code{lang}}{A character string,
      naming the language that is assumed for the tokenized texts in this object.}

\item{\code{desc}}{A named list of descriptive statistics of the tagged texts.}

\item{\code{meta}}{A named list. Can be used to store meta information. Currently,
      no particular format is defined.}

\item{\code{raw}}{A list of objects of class \code{\link[tm]{Corpus}}.}

\item{\code{tokens}}{A data frame as used for the \code{tokens} slot in objects of class \code{\link[koRpus:kRp.text-class]{kRp.text}}. In addition to the columns
usually found in those objects,
      this data frame also has a factor column for each hierarchical category defined (if any).}

\item{\code{features}}{A named logical vector,
      indicating which features are available in this object's \code{feat_list} slot.
Common features are listed in the description of the \code{feat_list} slot.}

\item{\code{feat_list}}{A named list with optional analysis results or other content as used by the defined \code{features}:
\itemize{
  \item{\code{hierarchy} }{A named list of named character vectors describing the directory hierarchy level by level.}
  \item{\code{hyphen} }{A named list of objects of class \code{\link[sylly:kRp.hyphen-class]{kRp.hyphen}}.}
  \item{\code{readability} }{A named list of objects of class \code{\link[koRpus:kRp.readability-class]{kRp.readability}}.}
  \item{\code{lex_div} }{A named list of objects of class \code{\link[koRpus:kRp.TTR-class]{kRp.TTR}}.}
  \item{\code{freq} }{The \code{freq.analysis} slot of a \code{\link[koRpus:kRp.txt.freq-class]{kRp.txt.freq}} class object after
    \code{\link[tm.plugin.koRpus:freq.analysis]{freq.analysis}} was called.}
  \item{\code{corp_freq} }{An object of class \code{\link[koRpus:kRp.corp.freq-class]{kRp.corp.freq}},
      e.g., results of a call to
    \code{\link[tm.plugin.koRpus:read.corp.custom]{read.corp.custom}}.}
  \item{\code{diff} }{A named list of \code{diff} features of a \code{\link[koRpus:kRp.text-class]{kRp.text}} object after
    a method like \code{\link[tm.plugin.koRpus:textTransform]{textTransform}} was called.}
  \item{\code{summary} }{A summary data frame for the full corpus,
      including descriptive statistics on all texts, as well as
    results of analyses like readability and lexical diversity, if available.}
  \item{\code{doc_term_matrix} }{A sparse document-term matrix,
      as produced by \code{\link[tm.plugin.koRpus:docTermMatrix]{docTermMatrix}}.}
  \item{\code{stopwords} }{A numeric vector with the total number of stopwords in each text,
      if stopwords were analyzed during tokenizing or POS tagging.}
}
See the \code{\link[tm.plugin.koRpus:kRp.corpus_get-methods]{getter and setter methods}} for easy access to these sub-slots.
There can actually be any number of additional features,
      the above is just a list of those already defined by this package.}
}}

\note{
There is also \code{\link[tm.plugin.koRpus:kRp.corpus_get-methods]{getter and setter methods}} for objects of this class.
}
\section{Contructor function}{

Should you need to manually generate objects of this class (which should rarely be the case),
      the contructor function 
\code{kRp.corpus(...)} can be used instead of
\code{new("kRp.corpus", ...)}. Whenever possible, stick to
\code{\link[tm.plugin.koRpus:readCorpus]{readCorpus}}.
}

\examples{
# use readCorpus() to create an object of class kRp.corpus
# code is only run when the english language package can be loaded
if(require("koRpus.lang.en", quietly = TRUE)){
  myCorpus <- readCorpus(
    dir=file.path(path.package("tm.plugin.koRpus"), "examples", "corpus"),
    hierarchy=list(
      Topic=c(
        Winner="Reality Winner",
        Edwards="Natalie Edwards"
      ),
      Source=c(
        Wikipedia_prev="Wikipedia (old)",
        Wikipedia_new="Wikipedia (new)"
      )
    ),
    # use tokenize() so examples run without a TreeTagger installation
    tagger="tokenize",
    lang="en"
  )
} else {}

# manual creation
emptyCorpus <- kRp.corpus()
}
\keyword{classes}
