% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tm_pos.R
\name{tm_pos}
\alias{tm_pos}
\alias{tm_pos_in}
\alias{tm_pos_out}
\alias{tm_pos_on_top}
\alias{tm_pos_auto_out}
\alias{tm_pos_auto_in}
\title{Set the position of map components}
\usage{
tm_pos(cell.h, cell.v, pos.h, pos.v, align.h, align.v, just.h, just.v)

tm_pos_in(pos.h, pos.v, align.h, align.v, just.h, just.v)

tm_pos_out(cell.h, cell.v, pos.h, pos.v, align.h, align.v, just.h, just.v)

tm_pos_on_top(pos.h, pos.v, align.h, align.v, just.h, just.v)

tm_pos_auto_out(cell.h, cell.v, pos.h, pos.v, align.h, align.v, just.h, just.v)

tm_pos_auto_in(align.h, align.v, just.h, just.v)
}
\arguments{
\item{cell.h, cell.v}{The plotting area is overlaid with a 3x3 grid, of which
the middle grid cell is the map area. Components can be drawn into any cell.
\code{cell.h} specifies the horizontal position (column) can take values
\code{"left"}, \code{"center"}, and \code{"right"}. \code{cell.v} specifies the vertical position
(row) and can take values \code{"top"}, \code{"center"}, and \code{"bottom"}.
See details for a graphical explanation.}

\item{pos.h, pos.v}{The position of the component within the cell.
The main options for \code{pos.h} are \code{"left"}, \code{"center"}, and \code{"right"}.
For \code{cell.v} these are \code{"top"}, \code{"center"}, and \code{"bottom"}.
These options can also be provided in upper case; in that case there is no offset
(see the tmap option \code{component.offset}). Also numbers between 0 and 1 can be provided,
which determine the position of the component inside the cell (with (0,0) being left bottom).
The arguments \code{just.h} and \code{just.v} determine the justification point.}

\item{align.h, align.v}{The alignment of the component in case multiple components are stacked.
When they are stacked horizontally, \code{align.v} determines how components
that are smaller in height than the available height (determined by the outer.margins
if specified and otherwise by the highest component) are justified:
\code{"top"}, \code{"center"}, or \code{"bottom"}. Similarly, \code{align.h} determines how components
are justified horizontally when they are stacked vertically: \code{"left"}, \code{"center"}, or \code{"right"}.}

\item{just.h, just.v}{The justification of the components.
Only used in case \code{pos.h} and \code{pos.v} are numbers.}
}
\description{
Set the position of map components, such as legends, title, compass, scale bar, etc.
\code{tm_pos()} is the function to position these components:
\code{tm_pos_out()} places the components outside the map area, \code{tm_pos_in()} inside the map area, and \code{tm_pos_on_top()} on top of the map
Each \code{position} argument of a map layer or component should be specified with
one of these functions.
The functions \code{tm_pos_auto_out()} and \code{tm_pos_auto_in()}
are used to set the components automatically, and should be used
via \code{\link[=tmap_options]{tmap_options()}}. See Details how the positioning works.
}
\details{
\code{tm_pos_in()} sets the position of the component(s) inside the maps area,
which is equivalent to the center-center cell (in case there are facets,
these are all drawn in this center-center cell).

\code{tm_pos_out()} sets the position of the component(s) outside the map.

\code{tm_pos_on_top()} is the same as \code{tm_pos_out}, but with the cell set to the center cell
It may be therefore seem similar to \code{tm_pos_in()}, but with an essential difference:
\code{tm_pos_in()} takes the map frame into account whereas \code{tm_pos_on_top()} does not.
#'
The amount of space that the top and bottom rows, and left and right columns
occupy is determined by the \code{\link[=tm_layout]{tm_layout()}} arguments \code{meta.margins} and \code{meta.auto_margins}.
The former sets the relative space of the bottom, left, top, and right side.
In case these are set to \code{NA}, the space is set automatically based on 1)
the maximum relative space specified by \code{meta.auto_margins} and 2)
the presence and size of components in each cell.
For instance, if there is one landscape oriented legend in the center-bottom cell,
then the relative space of the bottom row is set to the height of that legend
(given that it is smaller than the corresponding value of \code{meta.auto_margins}),
while the other four sides are set to 0.

\code{tm_pos_auto_out()} is more complex: the \code{cell.h} and \code{cell.v} arguments should be set
to one of the four corners. It does not mean that the components are drawn in a corner.
The corner represents the sides of the map that the components are drawn.
By default, legends are drawn either at the bottom or on the right-side of
the map by default (see \code{tmap_options("legend.position")}).
Only when there are row- and column-wise legends and a general legend (using \code{\link[=tm_facets_grid]{tm_facets_grid()}}),
the general legend is drawn in the corner, but in practice this case will be rare.

The arguments \code{pos.h} and \code{pos.v} determine where the components are drawn within the cell.
Again, with \code{"left"}, \code{"center"}, and \code{"right"} for \code{pos.h}
and \code{"top"}, \code{"center"}, and \code{"bottom"} for \code{pos.v}.
The values can also be specified in upper-case, which influences the offset
with the cell borders, which is determined by tmap option \code{component.offset}.
By default, there is a small offset when components are drawn inside and no
offset when they are drawn outside or with upper-case.

\code{tm_pos_auto_in()} automatically determines \code{pos.h} and \code{pos.v} given the
available space inside the map. This is similar to the default positioning in tmap3.

In case multiple components are draw in the same cell and the same position
inside that cell, they are stacked (determined which the \code{stack} argument in
the legend or component function). The \code{align.h} and \code{align.v} arguments
determine how these components will be justified with each other.

Note that legends and components may be different for a facet row or column.
This is the case when \code{\link[=tm_facets_grid]{tm_facets_grid()}} or \code{\link[=tm_facets_stack]{tm_facets_stack()}} are applied
and when scales are set to free (with the \code{.free} argument of the map layer functions).
In case a legends or components are draw row- or column wise, and the position
of the legends (or components) is right next to the maps, these legends
(or components) will be aligned with the maps.
}
\seealso{
\href{https://r-tmap.github.io/tmap/articles/adv_positions}{Vignette about positioning}
}
