% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/importance_glmnet.R
\name{importance.cv.glmnet}
\alias{importance.cv.glmnet}
\title{Plot Variable Importance for a GLMNET model}
\usage{
\method{importance}{cv.glmnet}(model_final, model_data, form, dict = NA, nperm = 500, ...)
}
\arguments{
\item{model_final}{a model object}

\item{model_data}{the data used to fit the model}

\item{form}{the model formula}

\item{dict}{a variable dictionary for plotting}

\item{nperm}{the number of permutations used to calculate the importance}

\item{...}{arguments passed to other methods}
}
\value{
an object of type \code{importance_plot}
\item{type}{the type of importance plot}
\item{data}{the importance data required for the plot}
}
\description{
Plot Variable Importance for a GLMNET model
}
\examples{
if (requireNamespace("glmnet", quietly = TRUE))
{
  form <- formula(mpg ~ cyl*wt*hp)
  mf <- model.frame(form, data = mtcars)
  mm <- model.matrix(mf, mf)
  gtest <- glmnet::cv.glmnet(x = mm, y = mtcars$mpg, family = "gaussian")
  imp <- importance(gtest, mtcars, form, nperm = 50)
  plot(imp)
}
}
\seealso{
\code{\link{importance}}
}
