% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bootstrap_traits_parametric.R
\name{trait_parametric_bootstrap}
\alias{trait_parametric_bootstrap}
\title{Bootstrap traits parametrically}
\usage{
trait_parametric_bootstrap(
  fitted_distributions,
  nrep = 100,
  sample_size = 200,
  raw = FALSE
)
}
\arguments{
\item{fitted_distributions}{Fitted distribution object returned by trait_fit_distributions}

\item{nrep}{number of bootstrap replicates}

\item{sample_size}{bootstrap size}

\item{raw}{logical; argument to extract the raw data of the
trait distributions.
The default is \code{raw = FALSE}.
If \code{raw = TRUE}, \code{nrep} is restricted to 1 to avoid
memory issues.}
}
\value{
a tibble
}
\description{
Function for parametric bootstrap resampling to calculate
community weighted trait mean and higher moments.
}
\details{
\code{trait_parametric_bootstrap()} is a parametric analogue of the
\code{trait_np_bootstrap()}.
It randomly samples from among the fitted distributions
proportionally to species abundance.
The number of samples per replicated are drawn
specified with the parameter sample_size,
and the number of replicates is specified
by the parameter\code{ nrep}.
From these distributions the function estimates the mean
and the higher moments including variance, skewness and kurtosis.

The output of \code{trait_parametric_bootstrap()} can be summarized using
\code{trait_summarize_boot_moments()}.
}
\examples{
library(dplyr)
data(community)
data(trait)

# Filter trait and community data to make example faster

community <- community |>
  filter(
    PlotID \%in\% c("A", "B"),
    Site == 1
  )

trait <- trait |>
  filter(Trait \%in\% c("Plant_Height_cm"))

filled_traits <- trait_fill(
  comm = community,
  traits = trait,
  scale_hierarchy = c("Site", "PlotID"),
  taxon_col = "Taxon", value_col = "Value",
  trait_col = "Trait", abundance_col = "Cover"
)

fitted_distributions <- trait_fit_distributions(
  filled_traits = filled_traits,
  distribution_type = "normal"
)

# Note that more replicates and a greater sample size are advisable
# Here we set them low to make the example run quickly
parametric_distributions <- trait_parametric_bootstrap(
  fitted_distributions = fitted_distributions,
  nrep = 5,
  sample_size = 100
)

moment_summary <- trait_summarise_boot_moments(
  bootstrap_moments = parametric_distributions,
  parametric = FALSE
)
}
