% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api_research_extended.r
\name{tt_user_videos_api}
\alias{tt_user_videos_api}
\title{Get videos from a TikTok user's profile}
\usage{
tt_user_videos_api(
  username,
  since = "2020-01-01",
  to = Sys.Date(),
  verbose = interactive(),
  ...
)
}
\arguments{
\item{username}{The username or usernames whose videos you want to retrieve.}

\item{since, to}{limits from/to when to go through the account in 30 day windows.}

\item{verbose}{should the function print status updates to the screen?}

\item{...}{Additional arguments to be passed to the
\code{\link{tt_search_api}} function.}
}
\value{
a data.frame containing metadata of user posts.
}
\description{
\ifelse{html}{\figure{api-research.svg}{options: alt='[Works on:
  Research API]'}}{\strong{[Works on: Research API]}}

Get all videos posted by a user or multiple user's. This is a convenience
wrapper around \code{\link{tt_search_api}} that takes care of moving time
windows (search is limited to 30 days). This is the version of
\link{tt_user_videos} that explicitly uses Research API. Use
\link{tt_user_videos_hidden} for the unofficial API version.
}
\examples{
\dontrun{
# Get videos from the user "fpoe_at" since October 2024
tt_user_videos_api("fpoe_at", since = "2024-10-01")

# often makes sense to combine this with the account creation time from the
# hidden URL
fpoe_at_info <- tt_user_info_hidden(username = "fpoe_at")
tt_user_videos_api("fpoe_at", since = fpoe_at_info$create_time)

}
}
