% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/liver_scores.R
\name{bar_score}
\alias{bar_score}
\title{BAR (Balance of Risk) score in liver transplantation}
\usage{
bar_score(Age, MELD, ReTx, LifeSupport, CIT, DonorAge)
}
\arguments{
\item{Age}{numeric vector of recipient ages in years}

\item{MELD}{numeric vector of MELD scores}

\item{ReTx}{numeric vector of whether retransplant (1 = "yes", 0 = "no")}

\item{LifeSupport}{numeric vector of whether on life support pre-transplant (1 = "yes", 0 = "no")}

\item{CIT}{numeric vector of cold ischaemic time in hours}

\item{DonorAge}{numeric vector of donor ages}
}
\value{
numeric vector of BAR scores
}
\description{
A vectorised function to calculate the BAR score to predict patient survival after liver
transplantation using a composite of donor and recipient factors.
}
\details{
Reference: Dutkowski P, Oberkofler CE, Slankamenac K, et al. Are There Better Guidelines for
Allocation in Liver Transplantation? A Novel Score Targeting Justice and Utility in the
Model for End-Stage Liver Disease Era. Annals of Surgery 2011; 254:745-753.
}
\examples{
bar_score(Age = 63, MELD = 27, ReTx = 0, LifeSupport = 0, CIT = 9.5, DonorAge = 67)
}
