% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tree_mesh.R
\name{tree_mesh}
\alias{tree_mesh}
\title{Generate a Tree Mesh}
\usage{
tree_mesh(
  crown_type = "oval",
  position = c(0, 0, 0),
  angle = 0,
  solid = FALSE,
  resolution = "medium",
  filename = NULL,
  tree_height = 1,
  trunk_height_ratio = NULL,
  crown_width_ratio = 1,
  crown_height = NULL,
  crown_width = NULL,
  trunk_height = NULL,
  trunk_width = NULL,
  crown_color = NA,
  trunk_color = "#8C6F5B",
  diffuse_intensity = 1,
  ambient_intensity = 0.2
)
}
\arguments{
\item{crown_type}{Default \code{"oval"}. Crown type (the leafy part of the tree). Full list of options:\tabular{cccc}{
   \strong{3D/Flat} \tab \strong{Name} \tab \strong{Crown Color} \tab \strong{Trunk Ratio} \cr
   Both \tab \code{"columnar"} \tab \code{"#A2C683"} \figure{columnarsquare.png} \tab 1/3 \cr
   Both \tab \code{"pyramidal1"} \tab \code{"#066038"} \figure{pyramidal1square.png} \tab 1/6 \cr
   Both \tab \code{"pyramidal2"} \tab \code{"#447765"} \figure{pyramidal2square.png} \tab 1/6 \cr
   Both \tab \code{"weeping"} \tab \code{"#CBD362"} \figure{weepingsquare.png} \tab 1/3 \cr
   Both \tab \code{"spreading1"} \tab \code{"#CCB471"} \figure{spreading1square.png} \tab 1/3 \cr
   Both \tab \code{"oval"} \tab \code{"#7CB262"} \figure{ovalsquare.png} \tab 1/3 \cr
   Flat-only \tab \code{"palm"} \tab \code{"#DB8952"} \figure{palmsquare.png} \tab 1/2 \cr
   Flat-only \tab \code{"rounded"} \tab \code{"#E0A854"} \figure{roundedsquare.png} \tab 1/3 \cr
   Flat-only \tab \code{"spreading2"} \tab \code{"#75C165"} \figure{spreading2square.png} \tab 1/3 \cr
   Flat-only \tab \code{"vase"} \tab \code{"#AECCB1"} \figure{vasesquare.png} \tab 1/3 \cr
}}

\item{position}{Default \code{c(0,0,0)}. A length-3 numeric vector specifying the X, Y, and Z coordinates of the tree mesh in 3D space.}

\item{angle}{Default \code{0}. Amount of rotation around the y-axis for the tree.}

\item{solid}{Default \code{FALSE}. Whether the crown should be a solid mesh (\code{TRUE}), or a collection of flat
2D planes (\code{FALSE}).}

\item{resolution}{Default \code{"medium"}. String indicating the level of detail of the tree mesh. All options:
\code{"low"}
\code{"medium"}
\verb{"high}}

\item{filename}{Default \code{NULL}. File name of the OBJ file, if saving the mesh to a local file.}

\item{tree_height}{Default \code{1}. A numeric value setting the total height of the tree.}

\item{trunk_height_ratio}{Default \code{NULL}. A numeric value specifying the ratio of the trunk height to the total height of the tree. If not provided, default values for each tree type will be used.}

\item{crown_width_ratio}{Default \code{1}. A numeric value specifying the ratio of the crown width to the crown height.}

\item{crown_height}{Default \code{NULL}. A numeric value setting the height of the crown. If not provided, it is calculated based on the tree height and trunk height ratio.}

\item{crown_width}{Default \code{NULL}. A numeric value setting the diameter of the crown. If not provided, it is calculated based on the crown height and crown width ratio.}

\item{trunk_height}{Default \code{NULL}. A numeric value setting the height of the trunk. If not provided, it is calculated based on the tree height and trunk height ratio.}

\item{trunk_width}{Default \code{NULL}. A numeric value setting the diameter of the trunk. If not provided, this is set to 1/10th the crown width.}

\item{crown_color}{Default \code{NA}, use default for crown type. A string specifying the hex code of the crown color.}

\item{trunk_color}{Default \code{"#8C6F5B"}. A string specifying the hex code of the trunk color.}

\item{diffuse_intensity}{Default \code{1.0}. A numeric value controlling the amount of diffuse (shaded) color included in the model.}

\item{ambient_intensity}{Default \code{0.2}. A numeric value controlling the amount of ambient (constant) color included in the model.}
}
\value{
\code{ray_mesh} list object
}
\description{
This function generates a tree model and transforms it into a \code{ray_mesh} object or an OBJ file.
The tree model consists of two main parts: the crown (leafy part) and the trunk. Both parts can be customized according
to a range of preset types, as well as full control over the tree's colors and dimensions.
The tree model can be positioned, scaled, and rotated in 3D space.
}
\examples{
#Load a tree and render it
library(rayvertex)
render_tree_example = function(example_tree_mesh) {
 example_tree_mesh |>
   add_shape(xz_rect_mesh(c(0,0,-9),
                          material = material_list(diffuse="tan",
                          ambient = "grey", diffuse_intensity = 0.7,
                          ambient_intensity = 0.6),
                          scale=25)) |>
   rasterize_scene(lookat=c(0,0.5,0),
                   light_info = directional_light(c(0.3,1,1), intensity = 0.7),
                   lookfrom=c(0,3,10),
                   fov=8,
                   shadow_map_dims = 2, shadow_map_bias = 0.0005,
                   width = 800, height = 800,
                   #fsaa = 4, ssao = TRUE, ssao_intensity = 1,
                   background = "lightblue")
}
if(run_documentation()) {
#Render a basic 3D crown
tree_mesh("columnar",
         solid = TRUE,
         ambient_intensity = 0.3) |>
 render_tree_example()
}
if(run_documentation()) {
#Render the 2D planar version
tree_mesh("columnar",
         solid = FALSE,
         ambient_intensity = 0.3) |>
 render_tree_example()
}
if(run_documentation()) {
#Adjust the trunk/crown proportions of the overall tree using ratios
tree_mesh("columnar",
         tree_height = 1,
         trunk_height_ratio = 1/5,
         crown_width_ratio = 1.25,
         trunk_width = 0.125,
         solid = TRUE,
         ambient_intensity = 0.3) |>
 render_tree_example()

}

if(run_documentation()) {
#The crown width is set proportional to the crown height (not the overall tree)
tree_mesh("columnar",
         tree_height = 1,
         trunk_height_ratio = 2/3,
         crown_width_ratio = 1,
         trunk_width = 0.075,
         solid = TRUE,
         ambient_intensity = 0.3) |>
 render_tree_example()
}

if(run_documentation()) {
#Set the trunk and crown dimensions directly
tree_mesh("columnar",
         trunk_height = 0.25,
         trunk_width = 0.05,
         crown_height = 0.75,
         crown_width = 0.33,
         solid = TRUE,
         ambient_intensity = 0.3) |>
 render_tree_example()
}
if(run_documentation()) {
#Change the crown and trunk color
tree_mesh("columnar",
         solid = TRUE,
         crown_color = "orange",
         trunk_color = "tan",
         ambient_intensity = 0.3) |>
 render_tree_example()
}
if(run_documentation()) {
#Render different tree types, both 2D and 3D versions
tree_mesh("columnar",
         solid = TRUE,
         ambient_intensity = 0.3) |>
 render_tree_example()
}
if(run_documentation()) {
tree_mesh("columnar",
         solid = FALSE,
         ambient_intensity = 0.3) |>
 render_tree_example()
}
if(run_documentation()) {
tree_mesh("pyramidal1",
         solid = TRUE,
         ambient_intensity = 0.3) |>
 render_tree_example()
}
if(run_documentation()) {
tree_mesh("pyramidal1",
         solid = FALSE,
         ambient_intensity = 0.3) |>
 render_tree_example()
}
if(run_documentation()) {
tree_mesh("pyramidal2",
         solid = TRUE,
         ambient_intensity = 0.3) |>
 render_tree_example()
}
if(run_documentation()) {
tree_mesh("pyramidal2",
         solid = FALSE,
         ambient_intensity = 0.3) |>
 render_tree_example()
}
if(run_documentation()) {
tree_mesh("weeping",
         solid = TRUE,
         ambient_intensity = 0.3) |>
 render_tree_example()
}
if(run_documentation()) {
tree_mesh("weeping",
         solid = FALSE,
         ambient_intensity = 0.3) |>
 render_tree_example()
}
if(run_documentation()) {
tree_mesh("spreading1",
         solid = TRUE,
         ambient_intensity = 0.3) |>
 render_tree_example()
}
if(run_documentation()) {
tree_mesh("spreading1",
         solid = FALSE,
         ambient_intensity = 0.3) |>
 render_tree_example()
}
if(run_documentation()) {
tree_mesh("oval",
         solid = TRUE,
         ambient_intensity = 0.3) |>
 render_tree_example()
}
if(run_documentation()) {
tree_mesh("oval",
         solid = FALSE,
         ambient_intensity = 0.3) |>
 render_tree_example()
}
if(run_documentation()) {
tree_mesh("palm",
         solid = FALSE,
         ambient_intensity = 0.3) |>
 render_tree_example()
}
if(run_documentation()) {
tree_mesh("rounded",
         solid = FALSE,
         ambient_intensity = 0.3) |>
 render_tree_example()
}
if(run_documentation()) {
tree_mesh("spreading2",
         solid = FALSE,
         ambient_intensity = 0.3) |>
 render_tree_example()
}
if(run_documentation()) {
tree_mesh("vase",
         solid = FALSE,
         ambient_intensity = 0.3) |>
 render_tree_example()
}
}
