% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_lost.R
\name{get_lost}
\alias{get_lost}
\title{Determine if a tip is present on a tree}
\usage{
get_lost(absent_list, tree)
}
\arguments{
\item{absent_list}{Vector of taxa in the total dataset that are not on the tree}

\item{tree}{Starting tree; object of type phylo}
}
\value{
not_found_df Dataframe objects expressing the tips that are not
        on the tree, and don"t have congeners
}
\description{
Determine which tips that are not on the tree, puts them in a dataframe if they
do not have congeners on the tree
}
\examples{
no_congeners <- treestartr:::get_lost(absent_list, tree)
}
