% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/func_post.R
\name{trem_post}
\alias{trem_post}
\title{Perform a POST request to Tremendous API}
\usage{
trem_post(
  client,
  path,
  query = list(),
  body = NULL,
  disk = NULL,
  stream = NULL,
  encode = "json",
  parse = TRUE
)
}
\arguments{
\item{client}{A Tremendous API Client object, created with
\code{\link{trem_client_new}}.}

\item{path}{The URL path, appended to the base URL, for GET requests such as
listing available payment types, funding sources, account members, and
more. See the \href{https://developers.tremendous.com/}{Tremendous API Documentation} for examples.}

\item{query}{Query terms as a named list. See \link[crul:HttpClient]{crul::HttpClient} for more
details.}

\item{body}{Request body for Tremendous API, as an R List.}

\item{disk}{A path to write to. \code{NULL} by default, so info is written to
memory. See \link[crul:HttpClient]{crul::HttpClient} for more details.}

\item{stream}{An R function to determine how to stream data. \code{NULL} by
default, so info is streaned with memory. See \link[crul:HttpClient]{crul::HttpClient} for more
details.}

\item{encode}{"json" by default based on Tremendous API Request format. See
\link[crul:HttpClient]{crul::HttpClient} for more options.}

\item{parse}{Logical: Should the API Response results be parsed into a data
frame?}
}
\value{
If \code{parse = TRUE} (default), a list containing the response from the
API request. Otherwise, the R6 HttpResponse object containing API request
data.
}
\description{
This function provides lower-level access to perform POST
requests via Tremendous API. Available endpoints can be found on the
official \href{https://developers.tremendous.com/}{Tremendous API documentation}.

For sending payments, I would recommend using \code{\link{trem_send_reward}} as
it's more intuitive to use. However, this can be done using the
\code{trem_post()} function (see examples).
}
\examples{

\dontrun{

  # Create a new Tremendous API Client
  test_client <- trem_client_new(api_key = "TEST_YOUR-API-KEY-HERE",
                                 sandbox = TRUE)

  # Perform a POST request to invite new members to your Tremendous Account.
  # Documentation: https://developers.tremendous.com/reference/post_members
    trem_post(trem_client,
              path = "members",
              body = list(email = "example@website.com",
                          name = "Example Person",
                          role = "MEMBER"))

  # Perform a POST send payments --
  I find it ~tremendously~ easier to use the `trem_send_reward()` function.
  # Documentation: https://developers.tremendous.com/reference/core-orders-create
    trem_post(trem_client,
              path = "orders",
              body = list(
                external_id = "manual-payment-post", # This is a payment description id
                payment = list(
                  funding_source_id = "your-funding-id-from-tremendous"
                ),
                rewards = list(
                  value = list(
                    denomination = 10,
                    currency_code = "USD"
                  ),
                  delivery = list(
                    method = "EMAIL" # "EMAIL", "LINK", or "PHONE",
                  ),
                  recipient = list(
                    name = "first last",
                    email = "email@website.com"
                  ),
                  # IDs for Applebee's Gift Card and Amazon Gift Card
                  products = c("2JFKPXBWDC1K", "VW9JLMPRL9N7")
                )
              ))

}


}
