% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xlsx.R
\name{write_xlsx}
\alias{write_xlsx}
\title{Write Data to Excel with Titles, Notes, and Styling}
\usage{
write_xlsx(
  data,
  path,
  ...,
  sheet_name = NULL,
  title = NULL,
  subtitle = NULL,
  source_note = NULL,
  footnotes = NULL,
  separate_files = FALSE,
  collapse_list = FALSE,
  row_group_as_column = FALSE,
  names_separator = "__",
  include_table_list = FALSE,
  table_list_reference = NULL,
  facade = get_tsg_facade()
)
}
\arguments{
\item{data}{A \code{data.frame}, tibble, or a named \code{list} of them. When a list is provided:
\itemize{
\item If \code{separate_files = FALSE}, each element is written to a separate sheet in one Excel file.
\item If \code{separate_files = TRUE}, each element is written to its own Excel file.
}}

\item{path}{A file path (if \code{separate_files = FALSE}) or directory path (if \code{separate_files = TRUE})
where the Excel file(s) will be saved. File extension \code{.xlsx} is automatically added if missing.}

\item{...}{Additional arguments passed to \code{openxlsx::createWorkbook()} and \code{openxlsx::addWorksheet()}.}

\item{sheet_name}{Optional name for the Excel sheet. Ignored if \code{data} is a list and \code{separate_files = FALSE}.}

\item{title}{Optional title displayed above the data in each sheet or file.}

\item{subtitle}{Optional subtitle displayed under the title.}

\item{source_note}{Optional source note displayed below the data.}

\item{footnotes}{Optional character vector of footnotes to display below the source note.}

\item{separate_files}{Logical. If \code{TRUE}, each list item in \code{data} is saved as a separate Excel file.}

\item{collapse_list}{Logical. If \code{TRUE}, a list of data frames will be merged into one sheet (if applicable).}

\item{row_group_as_column}{Logical. If \code{TRUE}, row groupings are included as columns instead of grouped titles.}

\item{names_separator}{Character used to separate column names when dealing with nested or grouped headers.}

\item{include_table_list}{Logical. If \code{TRUE}, a table list reference is included in the Excel file.}

\item{table_list_reference}{A data frame containing the table list reference. If \code{NULL}, it will be generated from \code{data}.}

\item{facade}{A list of styling options (colors, fonts, sizes, border styles, etc.). Defaults to the global option \code{tsg.options.facade}.}
}
\value{
Invisibly returns \code{NULL}. The function is called for its side-effect of writing Excel file(s).
}
\description{
Exports a data frame or a list of data frames to one or multiple Excel files,
with support for titles, subtitles, source notes, footnotes, grouping, and custom styles.
It leverages the \code{openxlsx} package to create styled Excel reports suitable for presentation.
}
\details{
This function supports advanced Excel formatting including:
\itemize{
\item Grouped headers
\item Dynamic column widths
\item Styled titles, subtitles, source notes, and footnotes
\item Border styling (inner, outer, header)
}

The function is designed to handle export needs in professional and reporting contexts.
}
\examples{
data <- tsg::generate_frequency(dplyr::starwars, sex)

dir_to <- tempfile()
write_xlsx(
  data,
  file.path(dir_to, "starwars_frequency.xlsx")
 )

}
