% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting.R
\name{plot_new_cases}
\alias{plot_new_cases}
\title{Plots the forecast of new cases (the difference of the cumulated
variable)}
\usage{
plot_new_cases(
  res,
  Y,
  n.ahead,
  confidence.level = 0.68,
  date_format = "\%Y-\%m-\%d",
  title = NULL,
  plt.start.date = NULL
)
}
\arguments{
\item{res}{Results object estimated using the \code{estimate()} method.}

\item{Y}{Cumulated variable.}

\item{n.ahead}{Number of forecasts (i.e. number of periods ahead to forecast
from end of estimation window).}

\item{confidence.level}{Width of prediction interval for \eqn{\ln g_t} to
use in forecasts of \eqn{y_t = \Delta Y_t}. Default is 0.68, which is
approximately one standard deviation for a Normal distribution.}

\item{date_format}{Date format. Default is \code{'\%Y-\%m-\%d'}.}

\item{title}{Title for forecast plot. Enter as text string. \code{NULL}
(i.e. no title) by default.}

\item{plt.start.date}{First date of actual data (from estimation sample) to
plot on graph.\code{NULL} (i.e. plots all data in estimation window) by
default.}
}
\value{
A \code{ggplot2} plot.
}
\description{
Plots actual values of the difference in the cumulated variable,
the forecasts of the cumulated variable (both including and excluding the
seasonal component, where a seasonal is specified) and forecast intervals
around the forecasts. The forecast intervals are based on the prediction
intervals for \eqn{\ln(g_t)}.
}
\examples{
library(tsgc)
data(gauteng,package="tsgc")
idx.est <- zoo::index(gauteng) <= as.Date("2020-07-20")

# Specify a model
model <- SSModelDynamicGompertz$new(Y = gauteng[idx.est], q = 0.005)
# Estimate a specified model
res <- model$estimate()

# Plot forecast of new cases 7 days ahead
plot_new_cases(res, Y = gauteng[idx.est], n.ahead = 7,
confidence.level = 0.68, date_format = "\%Y-\%m-\%d",
title = "Forecast new cases", plt.start.date = as.Date("2020-07-13"))

}
