% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract.R
\name{extract-tune}
\alias{extract-tune}
\alias{extract_workflow.last_fit}
\alias{extract_workflow.tune_results}
\alias{extract_spec_parsnip.tune_results}
\alias{extract_recipe.tune_results}
\alias{extract_fit_parsnip.tune_results}
\alias{extract_fit_engine.tune_results}
\alias{extract_mold.tune_results}
\alias{extract_preprocessor.tune_results}
\title{Extract elements of \code{tune} objects}
\usage{
\method{extract_workflow}{last_fit}(x, ...)

\method{extract_workflow}{tune_results}(x, ...)

\method{extract_spec_parsnip}{tune_results}(x, ...)

\method{extract_recipe}{tune_results}(x, ..., estimated = TRUE)

\method{extract_fit_parsnip}{tune_results}(x, ...)

\method{extract_fit_engine}{tune_results}(x, ...)

\method{extract_mold}{tune_results}(x, ...)

\method{extract_preprocessor}{tune_results}(x, ...)
}
\arguments{
\item{x}{A \code{tune_results} object.}

\item{...}{Not currently used.}

\item{estimated}{A logical for whether the original (unfit) recipe or the
fitted recipe should be returned.}
}
\value{
The extracted value from the \code{tune} tune_results, \code{x}, as described in the
description section.
}
\description{
These functions extract various elements from a tune object. If they do
not exist yet, an error is thrown.
\itemize{
\item \code{\link[=extract_preprocessor.tune_results]{extract_preprocessor()}} returns
the formula, recipe, or variable
expressions used for preprocessing.
\item \code{\link[=extract_spec_parsnip.tune_results]{extract_spec_parsnip()}} returns
the parsnip model specification.
\item \code{\link[=extract_fit_parsnip.tune_results]{extract_fit_parsnip()}} returns the
parsnip model fit object.
\item \code{\link[=extract_fit_engine.tune_results]{extract_fit_engine()}} returns the
engine specific fit embedded within
a parsnip model fit. For example, when using \code{\link[parsnip:linear_reg]{parsnip::linear_reg()}}
with the \code{"lm"} engine, this returns the underlying \code{lm} object.
\item \code{\link[=extract_mold.tune_results]{extract_mold()}} returns the preprocessed
"mold" object returned
from \code{\link[hardhat:mold]{hardhat::mold()}}. It contains information about the preprocessing,
including either the prepped recipe, the formula terms object, or
variable selectors.
\item \code{\link[=extract_recipe.tune_results]{extract_recipe()}} returns the recipe.
The \code{estimated} argument specifies
whether the fitted or original recipe is returned.
\item \code{\link[=extract_workflow.tune_results]{extract_workflow()}} returns the
workflow object if the control option
\code{save_workflow = TRUE} was used. The workflow will only have been
estimated for objects produced by \code{\link[=last_fit]{last_fit()}}.
}
}
\details{
These functions supersede \code{extract_model()}.
}
\examples{
\dontshow{if (rlang::is_installed("splines2")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# example code

library(recipes)
library(rsample)
library(parsnip)

set.seed(6735)
tr_te_split <- initial_split(mtcars)

spline_rec <- recipe(mpg ~ ., data = mtcars) |>
  step_spline_natural(disp)

lin_mod <- linear_reg() |>
  set_engine("lm")

spline_res <- last_fit(lin_mod, spline_rec, split = tr_te_split)

extract_preprocessor(spline_res)

# The `spec` is the parsnip spec before it has been fit.
# The `fit` is the fitted parsnip model.
extract_spec_parsnip(spline_res)
extract_fit_parsnip(spline_res)
extract_fit_engine(spline_res)

# The mold is returned from `hardhat::mold()`, and contains the
# predictors, outcomes, and information about the preprocessing
# for use on new data at `predict()` time.
extract_mold(spline_res)

# A useful shortcut is to extract the fitted recipe from the workflow
extract_recipe(spline_res)

# That is identical to
identical(
  extract_mold(spline_res)$blueprint$recipe,
  extract_recipe(spline_res)
)
\dontshow{\}) # examplesIf}
}
