% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/centeredBasis_gen.R
\name{centeredBasis.gen}
\alias{centeredBasis.gen}
\title{Generation of a recentered cubic B-spline basis matrix.}
\usage{
centeredBasis.gen(x, knots, cm = NULL, pen.order = 2)
}
\arguments{
\item{x}{Vector of values where the "recentered" B-spline basis is evaluated.}

\item{knots}{Vector of knots that must cover the values in \code{x}.}

\item{cm}{(Optional) values subtracted from each column of the original B-spline matrix.}

\item{pen.order}{Order of the penalty applied on B-spline parameters. (Default: 2).}
}
\value{
List containing
\itemize{
\item \code{B} : centered cubic B-spline matrix obtained by subtracting \code{cm[j]} from the jth B-spline in column j of the original B-spline matrix evaluated at \code{x}.
\item \code{Dd} : difference matrix (of order \code{pen.order}) for the associated centered B-spline matrix.
\item \code{Pd} : penalty matrix (of order \code{pen.order}) for the associated centered B-spline matrix.
\item \code{K} : number of centered B-splines in the basis.
\item \code{cm} : values subtracted from each column of the original B-spline matrix. By default, this is a vector containing the mean of each column in the original B-spline matrix.
}
}
\description{
Generation of a cubic B-spline basis matrix with recentered columns
 to handle the identifiability constraint in additive models. See Wood (CRC Press 2017, pp. 175-176) for more details.
}
\examples{
x = seq(0,1,by=.01)
knots = seq(0,1,length=5)
obj = centeredBasis.gen(x,knots)
matplot(x,obj$B,type="l",ylab="Centered B-splines")
colMeans(obj$B)

}
\references{
Lambert, P. and Kreyenfeld, M. (2025).
Time-varying exogenous covariates with frequently changing values in double additive cure survival model: an application to fertility.
\emph{Journal of the Royal Statistical Society, Series A}. <doi:10.1093/jrsssa/qnaf035>
}
\author{
Philippe Lambert \email{p.lambert@uliege.be}
}
