% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tvtools.R
\name{measurement.rate}
\alias{measurement.rate}
\title{measurement.rate}
\usage{
measurement.rate(
  dat,
  id.name = "id",
  t1.name = "t1",
  t2.name = "t2",
  time.point = 0,
  grouping.variables = NULL
)
}
\arguments{
\item{dat}{A data frame structured as panel data.}

\item{id.name}{The character name of the identifying variable within dat, used to
track subjects across multiple rows.}

\item{t1.name}{The character name of the time variable within dat representing the
start (left endpoint) of observation intervals.}

\item{t2.name}{The character name of the time variable within dat representing the
end (right endpoint) of observation intervals.}

\item{time.point}{A numeric value specifying the point in time at which the measurement
rate should be calculated. Subjects observed at this point are considered active.}

\item{grouping.variables}{A character vector of variable names from dat used to group
the results. Proportions are calculated within these groups.}
}
\value{
Returns a data table that includes the specified grouping variables, the number
of subjects observed at the given time.point, the total number of unique subjects, and
two calculated rates: 'rate.observed' and 'rate.not.observed'. 'rate.observed' is the
proportion of subjects active at the specified time point, and 'rate.not.observed' is the
proportion no longer observed. This output is instrumental for analyzing subject retention
and attrition over the course of the study.
}
\description{
Calculates the proportion of unique subjects remaining under observation
and those no longer observed at a specified time point during the follow-up period
within a panel data structure. This metric is crucial for evaluating the coverage and
retention of subjects in longitudinal studies.
}
