% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/twoStageTMLE.R
\name{twoStageTMLE}
\alias{twoStageTMLE}
\title{twoStageTMLE}
\usage{
twoStageTMLE(
  Y,
  A,
  W,
  Delta.W,
  W.stage2,
  Z = NULL,
  Delta = rep(1, length(Y)),
  pi = NULL,
  piform = NULL,
  pi.SL.library = c("SL.glm", "SL.gam", "SL.glmnet", "tmle.SL.dbarts.k.5"),
  V.pi = 10,
  pi.discreteSL = TRUE,
  condSetNames = c("A", "W", "Y"),
  id = NULL,
  Q.family = "gaussian",
  augmentW = TRUE,
  augW.SL.library = c("SL.glm", "SL.glmnet", "tmle.SL.dbarts2"),
  rareOutcome = FALSE,
  verbose = FALSE,
  ...
)
}
\arguments{
\item{Y}{outcome}

\item{A}{binary treatment indicator}

\item{W}{covariate matrix observed on everyone}

\item{Delta.W}{binary indicator of missing second stage covariates}

\item{W.stage2}{matrix of second stage covariates observed on subset
of observations}

\item{Z}{optional mediator of treatment effect for evaluating a
controlled direct effect}

\item{Delta}{binary indicator of missing value for outcome \code{Y}}

\item{pi}{optional vector of missingness probabilities for \code{W.stage2}}

\item{piform}{parametric regression formula for estimating \code{pi} (see Details)}

\item{pi.SL.library}{super learner library for estimating \code{pi} (see Details)}

\item{V.pi}{number of cross validation folds for estimating \code{pi}
using super learner}

\item{pi.discreteSL}{Use discrete super learning when \code{TRUE}, otherwise
ensemble super learning}

\item{condSetNames}{Variables to include as predictors of missingness
in \code{W.stage2}, any combination of \code{Y, A}, and either \code{W} (for all
covariates in \code{W}), or individual covariate names in \code{W}}

\item{id}{Identifier of independent units of observation, e.g., clusters}

\item{Q.family}{Regression family for the outcome}

\item{augmentW}{When \code{TRUE} include predicted values for the outcome
the set of covariates used to model the propensity score}

\item{augW.SL.library}{super learner library for preliminary outcome
regression model (ignored when \code{augmentW} is \code{FALSE})}

\item{rareOutcome}{When \code{TRUE} specifies less ambitious SL for Q in call
to \code{tmle} (discreteSL, glm, glmnet, bart library, \code{V=20})}

\item{verbose}{When \code{TRUE} prints informational messages}

\item{...}{other parameters passed to the tmle function (not checked)}
}
\value{
object of class 'twoStageTMLE'.
\item{tmle}{Treatment effect estimates and summary information}
\item{twoStage}{IPCW weight estimation summary, \code{pi} are the probabilities,
\code{coef} are SL weights or coefficients from glm fit, \code{type} of
estimation procedure, \code{discreteSL} flag indicating whether discrete
super learning was used}
\item{augW}{Matrix of predicted outcomes based on stage 1 covariates only}
}
\description{
Inverse probability of censoring weighted TMLE for evaluating
parameters when the full set of covariates is available on only
a subset of observations.
}
\details{
When using \code{piform} to specify a parametric model for pi that conditions
on the outcome use \code{Delta.W} as the dependent variable and \code{Y.orig}
on the right hand side of the formula instead of \code{Y}. When writing a
user-defined SL wrapper for inclusion in \code{pi.SL.library} use \code{Y}
on the left hand side of the formula. If specific covariate names are
used on the right hand side use \code{Y.orig} to condition
on the outcome.
}
\examples{
n <- 1000
W1 <- rnorm(n)
W2 <- rnorm(n)
W3 <- rnorm(n)
A <- rbinom(n, 1, plogis(-1 + .2*W1 + .3*W2 + .1*W3))
Y <- 10 + A + W1 + W2 + A*W1 + W3 + rnorm(n)
d <- data.frame(Y, A, W1, W2, W3)
# Set 400 with data on W3, more likely if W1 > 1
n.sample <- 400
p.sample <- 0.5 + .2*(W1 > 1)
rows.sample <- sample(1:n, size = n.sample, p = p.sample)
Delta.W <- rep(0,n)
Delta.W[rows.sample] <- 1
W3.stage2 <- cbind(W3 = W3[Delta.W==1])
#1. specify parametric models and do not augment W (fast, but not recommended)
result1 <- twoStageTMLE(Y=Y, A=A, W=cbind(W1, W2), Delta.W = Delta.W, 
   W.stage2 = W3.stage2, piform = "Delta.W~ I(W1 > 0) + Y.orig", V.pi= 5,
   verbose = TRUE, Qform = "Y~A+W1",gform="A~W1 + W2 +W3", augmentW = FALSE)
summary(result1)
\donttest{
#2. specify a parametric model for conditional missingness probabilities (pi)
#   and use default values to estimate marginal effect using \code{tmle}
result2 <- twoStageTMLE(Y=Y, A=A, W=cbind(W1, W2), Delta.W = Delta.W, 
     W.stage2 = cbind(W3)[Delta.W == 1], piform = "Delta.W~ I(W1 > 0)", 
     V.pi= 5,verbose = TRUE)
result2
}
}
\seealso{
\itemize{
\item \code{\link[tmle:tmle]{tmle::tmle()}} for details on customizing the estimation procedure
\item \code{\link[=twoStageTMLEmsm]{twoStageTMLEmsm()}} for estimating conditional effects
\item S Rose and MJ van der Laan. A Targeted Maximum Likelihood Estimator for
Two-Stage Designs. \emph{Int J Biostat.} 2011 Jan 1; 7(1): 17.
\doi{doi:10.2202/1557-4679.1217}
}
}
