% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/documentation.R, R/two_samples.R
\name{ks_test}
\alias{ks_test}
\alias{ks_stat}
\title{Kolmogorov-Smirnov Test}
\usage{
ks_test(a, b, nboots = 2000, p = default.p, keep.boots = T, keep.samples = F)

ks_stat(a, b, power = def_power)
}
\arguments{
\item{a}{a vector of numbers (or factors -- see details)}

\item{b}{a vector of numbers}

\item{nboots}{Number of bootstrap iterations}

\item{p}{power to raise test stat to}

\item{keep.boots}{Should the bootstrap values be saved in the output?}

\item{keep.samples}{Should the samples be saved in the output?}

\item{power}{power to raise test stat to}
}
\value{
Output is a length 2 Vector with test stat and p-value in that order. That vector has 3 attributes -- the sample sizes of each sample, and the number of bootstraps performed for the pvalue.
}
\description{
A two-sample test using the Kolmogorov-Smirnov test statistic (\code{ks_stat}).
}
\details{
The KS test compares two ECDFs by looking at the maximum difference between them. Formally -- if E is the ECDF of sample 1 and F is the ECDF of sample 2, then \deqn{KS = max |E(x)-F(x)|^p} for values of x in the joint sample. The test p-value is calculated by randomly resampling two samples of the same size using the combined sample.

In the example plot below, the KS statistic is the height of the vertical black line.

\figure{ks.png}{Example KS stat plot}

Inputs \code{a} and \code{b} can also be vectors of ordered (or unordered) factors, so long as both have the same levels and orderings. When possible, ordering factors will substantially increase power.
}
\section{Functions}{
\itemize{
\item \code{ks_test()}: Permutation based two sample Kolmogorov-Smirnov test

\item \code{ks_stat()}: Permutation based two sample Kolmogorov-Smirnov test

}}
\examples{
set.seed(314159)
vec1 = rnorm(20)
vec2 = rnorm(20,0.5)
out = ks_test(vec1,vec2)
out
summary(out)
plot(out)

# Example using ordered factors
vec1 = factor(LETTERS[1:5],levels = LETTERS,ordered = TRUE)
vec2 = factor(LETTERS[c(1,2,2,2,4)],levels = LETTERS, ordered=TRUE)
ks_test(vec1,vec2)
}
\seealso{
\code{\link[=dts_test]{dts_test()}} for a more powerful test statistic. See \code{\link[=kuiper_test]{kuiper_test()}} or \code{\link[=cvm_test]{cvm_test()}} for the natural successors to this test statistic.
}
