% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/serial_interval.R
\docType{data}
\name{du_serial_interval}
\alias{du_serial_interval}
\title{Serial interval from publicly reported cases}
\format{
An object of class \code{tbl_df} (inherits from \code{tbl}, \code{data.frame}) with 752 rows and 3 columns.
}
\source{
\url{https://github.com/MeyersLabUTexas/COVID-19}
}
\usage{
data("du_serial_interval")
}
\description{
Data on which initial serial interval estimates were performed by Du et al,
2020.
}
\details{
"This is a publication of the U.S. Government. This publication is in the
public domain and is therefore without copyright. All text from this work may
be reprinted freely. Use of these materials should be properly cited."
\subsection{\code{du_serial_interval} dataframe with 752 rows and 3 columns}{

\describe{
\item{ \code{id} (dbl) }{
Unique case id
}
\item{ \code{symptom_onset} (dbl) }{
Time of symptom onset as an integer
}
\item{ \code{infector_id} (dbl) }{
Case id of infector where known
}
}
}
}
\examples{
dplyr::glimpse(du_serial_interval)
}
\references{
Z. Du, X. Xu, Y. Wu, L. Wang, B. J. Cowling, and L. A. Meyers,
‘Serial Interval of COVID-19 among Publicly Reported Confirmed Cases’, Emerg
Infect Dis, vol. 26, no. 6, pp. 1341–1343, Jun. 2020, doi:
10.3201/eid2606.200357.
}
\concept{datasets}
\keyword{datasets}
