% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/classify_files.R
\name{classify_files}
\alias{classify_files}
\title{Classify FTMS files into categories based on filename patterns}
\usage{
classify_files(
  fi,
  search_col = "link_rawdata",
  id_col = "file_id",
  patterns = list(blank = c("blk", "blank", "MQ"), standard = c("srfa", "standard"), pool
    = c("pool")),
  include_blank_check = TRUE,
  return = c("list", "table")
)
}
\arguments{
\item{fi}{\code{data.table}. Must contain the columns specified in
\code{search_col} and \code{id_col}.}

\item{search_col}{Character. Name of the column used for pattern matching.
Defaults to \code{"link_rawdata"}.}

\item{id_col}{Character. Name of the column whose values are returned for
each category. Defaults to \code{"file_id"}.}

\item{patterns}{Named list of character vectors.
Each list entry is a category name, and its value is a vector of patterns.}

\item{include_blank_check}{Logical; if TRUE and \code{blank_check} exists, it is
used to assign \code{"blank"}.}

\item{return}{Either \code{"list"} (default) or \code{"table"}.
\itemize{
\item \code{"list"} → named list of ID vectors
\item \code{"table"} → \code{fi} with added column \code{category_analysis}
}}
}
\value{
Named list or a classified \code{data.table}.
}
\description{
Classifies entries into categories (blank, standard, pool, sample, …)
based on pattern rules applied to a specific search column.
The identifiers returned in each category are also configurable.
}
\details{
Default behavior:
\itemize{
\item \code{"blank"}: \code{blank_check == "blank"} or pattern \code{"blk"}
\item \code{"standard"}: pattern \code{"srfa"}
\item \code{"pool"}: pattern \code{"pool"}
\item \code{"sample"}: everything unmatched
}

Pattern matching is case-insensitive.
}
\examples{
# Minimal demo data
fi <- data.table::data.table(
  file_id       = 1:6,
  filename      = c("NS_blk_01.raw", "SRFA_20.raw", "Pool_A.raw",
                    "Sample_01.raw", "Sample_02.raw", "MQ_blank.raw"),
  blank_check   = c("blank", NA, NA, NA, NA, "blank"),  # optional column
  link_rawdata  = c("NS_blk_01.raw", "SRFA_20.raw", "Pool_A.raw",
                    "Sample_01.raw", "Sample_02.raw", "MQ_blank.raw")
)

# 1) Default behavior: return named list of file_ids by category
classify_files(fi)

# 2) Use a different column for pattern matching
classify_files(fi, search_col = "filename")

# 3) Return another ID field (here: file_id → stays the same for demo)
classify_files(fi, id_col = "file_id")

# 4) Return the full table with new category column
classify_files(fi, return = "table")
}
\concept{helper}
