% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/uncertainUCDP.R
\name{mean_uncertainUCDP}
\alias{mean_uncertainUCDP}
\alias{median_uncertainUCDP}
\alias{quantile_uncertainUCDP}
\title{Mean, median, and quantiles of the parametric uncertainty distributions for UCDP events}
\usage{
mean_uncertainUCDP(fatalities, tov = c("sb", "ns", "os", "any"))

median_uncertainUCDP(fatalities, tov = c("sb", "ns", "os", "any"))

quantile_uncertainUCDP(probs, fatalities, tov = c("sb", "ns", "os", "any"))
}
\arguments{
\item{fatalities}{A vector of non-negative integers representing the number of fatalities of the UCDP events. Non-integer values are allowed but should be considered experimental.}

\item{tov}{A character string representing the type of violence of the UCDP. Must be one of "sb", "ns", "os", or "any". The options are:

* "sb" for state-based violence
* "ns" for non-state violence
* "os" for one-sided violence
* "any" for parameters estimated across all type of violence. This is somewhat experimental and should be used with caution. This is possibly useful when the type of violence is unknown or when the user wants to combine all types of violence into a single category.}

\item{probs}{A numeric vector of probabilities with values in [0,1]. The quantiles to calculate.}
}
\value{
A numeric vector of the same length as the input vector of fatalities representing the means, medians, and quantiles of the parametric uncertainty distribution for each UCDP event.
}
\description{
Mean, median, and quantiles of the parametric uncertainty distributions for UCDP events. The parametric uncertainty distributions are based on the reported-value inflation Gumbel mixture distribution. The \code{median} and \code{quantile} functions are shortcuts for the \code{quncertainUCDP} function.
}
\examples{

data(ucdpged)

# Calculate the mean for an arbitrary UCDP event
mean_uncertainUCDP(fatalities = 100, tov = 'sb')

# Calculate the mean for the first event in the UCDP GED sample
mean_uncertainUCDP(ucdpged$best[1], tov = ucdpged$type_of_violence[1])

# Calculate the median for an arbitrary UCDP event
median_uncertainUCDP(fatalities = 100, tov = 'sb')

# Calculate the median for the first event in the UCDP GED sample
median_uncertainUCDP(ucdpged$best[1], tov = ucdpged$type_of_violence[1])

# Calculate the 90th percentile for an arbitrary UCDP event
quantile_uncertainUCDP(probs = 0.9, fatalities = 100, tov = 'sb')

# Calculate the 90th percentile for the first event in the UCDP GED sample
quantile_uncertainUCDP(ucdpged$best[1], 0.9, tov = ucdpged$type_of_violence[1])

}
