% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/paged_simple.R
\name{paged_simple}
\alias{paged_simple}
\title{Function for UNHCR paged simple template}
\usage{
paged_simple(back_html = TRUE, other_css = NULL, number_sections = FALSE, ...)
}
\arguments{
\item{back_html}{Back-cover HTML including contact information}

\item{other_css}{Add extra css}

\item{number_sections}{Number section headings}

\item{...}{Arguments passed to pagedown::html_paged}
}
\value{
An R Markdown output format.
}
\description{
Function for UNHCR paged simple template
}
\examples{
\dontrun{
# Requires pandoc

# Create an R Markdown example file
rmd_content <- "---
 title: 'Example UNHCR HTML'
 subtitle: 'Paged Report Simple'
 output: unhcrdown::paged_simple
 ---

 ## Introduction

 This is an example of a UNHCR-branded HTML paged report siple using `unhcrdown::paged_simple`.
 "

# Write the R Markdown content to a file
example_file <- tempfile(fileext = ".Rmd")
writeLines(rmd_content, example_file)

# Render the R Markdown file
rmarkdown::render(example_file,
  output_format = unhcrdown::paged_simple(),
  output_dir = tempdir()
)

# View the rendered HTML file
browseURL(render_file)
}
}
