% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Northwestern.R
\docType{data}
\name{northwestern_1}
\alias{northwestern_1}
\title{Primary colors of Northwestern University, USA}
\format{
An object of class \code{character} of length 22.
}
\source{
Color definitions are based on the
\href{https://www.northwestern.edu/brand/visual-identity/color-palettes/}{Color manual}.
}
\usage{
northwestern_1
}
\value{
A named vector of colors (HEX/HTML codes of type character).
}
\description{
\code{northwestern_1} provides the 20 primary colors
of the \href{https://www.northwestern.edu}{Northwestern University}, USA.
}
\details{
The visual branding relies almost exclusively on a proprietary Northwestern Purple (Purple 100) and its tints and shades.
By using a range of tones, we add flexibility without sacrificing the recognition and equity of our heritage color.
The range of tones runs from Northwestern Purple 160 (darkest) to Northwestern Purple 10 (lightest).
Anything darker or lighter loses its connection to Northwestern Purple.

Primary colors are
\code{"northwestern_Purple"} (defined as RGB 78/42/132, HEX #4E2A84),
\code{"purple_160"} (defined as RGB 29/2/53),
\code{"purple_150"} (defined as RGB 38/8/65),
\code{"purple_140"} (defined as RGB 48/16/78),
\code{"purple_130"} (defined as RGB 56/23/90),
\code{"purple_120"} (defined as RGB 64/31/104, HEX #401F68),
\code{"purple_110"} (defined as RGB 72/36/118),
\code{"purple_90"} (defined as RGB 91/59/140),
\code{"purple_80"} (defined as RGB 104/76/150),
\code{"purple_70"} (defined as RGB 118/93/160),
\code{"purple_60"} (defined as RGB 131/110/170, HEX #836EAA),
\code{"purple_50"} (defined as RGB 147/128/182),
\code{"purple_40"} (defined as RGB 164/149/195),
\code{"purple_30"} (defined as RGB 182/172/209, HEX #B6ACD1),
\code{"purple_20"} (defined as RGB 204/196/223),
\code{"purple_10"} (defined as RGB 228/224/238, HEX #E4E0EE),
\code{"rich_black"} (defined as RGB 0 0 0 or HEX #000000),
\code{"rich_black_80"} (defined as HEX #342F2E),
\code{"rich_black_50"} (defined as HEX #716C6B),
\code{"rich_black_20"} (defined as HEX #BBB8B8), and
\code{"rich_black_10"} (defined as HEX #D8D6D6).

\code{northwestern_1} uses HEX and RGB color definitions.
}
\examples{
northwestern_1
unikn::seecol(northwestern_1, main = "Primary colors of NW") # view color palette

}
\seealso{
\code{\link{northwestern_2}} for secondary colors of Northwestern University;
\code{\link[unikn]{seecol}} for viewing and comparing color palettes;
\code{\link[unikn]{usecol}} for using color palettes;
\code{\link[unikn]{simcol}} for finding similar colors;
\code{\link[unikn]{newpal}} for defining new color palettes;
\code{\link[unikn]{grepal}} for finding named colors.

Other U.S. university color palettes: 
\code{\link{asu_1}},
\code{\link{asu_2}},
\code{\link{asu_3}},
\code{\link{berkeley_1}},
\code{\link{berkeley_2}},
\code{\link{brown_1}},
\code{\link{brown_2}},
\code{\link{bu}},
\code{\link{caltech_1}},
\code{\link{caltech_2}},
\code{\link{caltech_3}},
\code{\link{cmu_1}},
\code{\link{cmu_2}},
\code{\link{cmu_3}},
\code{\link{columbia_1}},
\code{\link{columbia_2}},
\code{\link{columbia_3}},
\code{\link{cornell_1}},
\code{\link{cornell_2}},
\code{\link{cornell_3_accent}},
\code{\link{dartmouth_1}},
\code{\link{dartmouth_2}},
\code{\link{dartmouth_3}},
\code{\link{duke_1}},
\code{\link{duke_2}},
\code{\link{harvard_1}},
\code{\link{harvard_2}},
\code{\link{harvard_3}},
\code{\link{jhu_0}},
\code{\link{jhu_1}},
\code{\link{jhu_2}},
\code{\link{jhu_3_accent}},
\code{\link{jhu_4_gray}},
\code{\link{manchester_uni_1}},
\code{\link{manchester_uni_2}},
\code{\link{michigan_1}},
\code{\link{michigan_2}},
\code{\link{minnesotatwin_1}},
\code{\link{minnesotatwin_2}},
\code{\link{mit}},
\code{\link{monash_1}},
\code{\link{monash_2}},
\code{\link{msu}},
\code{\link{northwestern_2}},
\code{\link{notredame_1}},
\code{\link{notredame_2}},
\code{\link{nyu_1}},
\code{\link{nyu_2}},
\code{\link{nyu_accent}},
\code{\link{nyu_neutral}},
\code{\link{ohio_uni_1}},
\code{\link{ohio_uni_2}},
\code{\link{pitt_1}},
\code{\link{pitt_2}},
\code{\link{princeton_0}},
\code{\link{princeton_1}},
\code{\link{princeton_2}},
\code{\link{rpi_1}},
\code{\link{rpi_2}},
\code{\link{rpi_3}},
\code{\link{stanford_1}},
\code{\link{stanford_2}},
\code{\link{stanford_3}},
\code{\link{uchicago_1}},
\code{\link{uchicago_2}},
\code{\link{uci_1}},
\code{\link{uci_2}},
\code{\link{uci_3}},
\code{\link{uci_4}},
\code{\link{ucla_1}},
\code{\link{ucla_2}},
\code{\link{ucla_3}},
\code{\link{ucla_4}},
\code{\link{ucsd_1}},
\code{\link{ucsd_2}},
\code{\link{ucsd_3}},
\code{\link{uflorida_1}},
\code{\link{uflorida_2}},
\code{\link{uflorida_3}},
\code{\link{umass_1}},
\code{\link{umass_2}},
\code{\link{umass_neutrals}},
\code{\link{upenn_1}},
\code{\link{upenn_2}},
\code{\link{vanderbilt_1}},
\code{\link{vanderbilt_2}},
\code{\link{vanderbilt_3}},
\code{\link{willamette}},
\code{\link{wm_1}},
\code{\link{wm_2}},
\code{\link{wm_3}},
\code{\link{yale}},
\code{\link{yeshiva}}
}
\author{
\strong{unicol}, 2023-06-14.
}
\concept{U.S. university color palettes}
\keyword{datasets}
