% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Waikato.R
\docType{data}
\name{waikato}
\alias{waikato}
\title{Colours of the University of Waikato, NZ}
\format{
An object of class \code{character} of length 8.
}
\source{
Color definitions are based on Waikato's 
\href{https://brandguides.brandfolder.com/the-university-of-waikato-brandguide-0}{brand standards}.
}
\usage{
waikato
}
\value{
A named vector of colors (HEX/HTML codes of type character).
}
\description{
\code{waikato} provides the eight official web colours 
of the \href{https://www.waikato.ac.nz/}{University of Waikato}, New Zealand.
}
\details{
The 8 official web colours are
\code{"Waikato light red"} (defined as HEX #D40100),
\code{"Waikato medium red"} (defined as HEX #BE0403),
\code{"Waikato dark red"} (defined as HEX #AA0000),
\code{"Waikato light yellow"} (defined as HEX #FAA61A),
\code{"Waikato darker yellow"} (defined as HEX #E79000),
\code{"Waikato dark grey"} (defined as HEX #353535),
\code{"Waikato blue grey"} (defined as HEX #32373D), and
\code{"Waikato light grey"} (defined as HEX #F2F2F2).

\code{waikato} uses the HEX color definitions.
}
\examples{
waikato
unikn::seecol(waikato, main = "Colors of the University of Waikato") # view colour palettes

}
\seealso{
\code{\link[unikn]{seecol}} for viewing and comparing color palettes;
\code{\link[unikn]{usecol}} for using color palettes;
\code{\link[unikn]{simcol}} for finding similar colors;
\code{\link[unikn]{newpal}} for defining new color palettes;
\code{\link[unikn]{grepal}} for finding named colors.

Other New Zealand university color palettes: 
\code{\link{auckland_1}},
\code{\link{auckland_2}},
\code{\link{otago}}
}
\author{
\strong{unicol}, 2023-07-05.
}
\concept{New Zealand university color palettes}
\keyword{datasets}
