% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mlsstd.R
\name{mlsstd}
\alias{mlsstd}
\title{Skew Student t-distribution maximum likelihood estimation}
\usage{
mlsstd(x, na.rm = FALSE, ...)
}
\arguments{
\item{x}{a (non-empty) numeric vector of data values.}

\item{na.rm}{logical. Should missing values be removed?}

\item{...}{currently affects nothing.}
}
\value{
\code{mlsstd} returns an object of \link[base:class]{class} \code{univariateML}.
This is a named numeric vector with maximum likelihood estimates for
the parameters \code{mean}, \code{sd}, \code{nu}, \code{xi} and the following attributes:
\item{\code{model}}{The name of the model.}
\item{\code{density}}{The density associated with the estimates.}
\item{\code{logLik}}{The loglikelihood at the maximum.}
\item{\code{support}}{The support of the density.}
\item{\code{n}}{The number of observations.}
\item{\code{call}}{The call as captured my \code{match.call}}
}
\description{
Joint maximum likelihood estimation as implemented by \link[fGarch:dist-sstdFit]{fGarch::sstdFit}.
}
\details{
For the density function of the skew Student t-distribution see
\link[fGarch:dist-sstd]{sstd}.
}
\examples{
mlsstd(precip)
}
\references{
Fernandez C., Steel M.F.J. (2000); On Bayesian Modelling of Fat
Tails and Skewness, Preprint.
}
\seealso{
\link[fGarch:dist-sstd]{sstd} for the Skew Student t-density.
}
