% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nass_set_key.R
\name{nass_set_key}
\alias{nass_set_key}
\title{Set a Quick Stats API key}
\usage{
nass_set_key(key = NULL, overwrite = FALSE)
}
\arguments{
\item{key}{The API key provided to you from NASS formatted in quotes. A key
can be acquired at \url{https://quickstats.nass.usda.gov/api}}

\item{overwrite}{If this is set to TRUE, it will write an existing
NASS_KEY that you already have in your \code{.Renviron} file.}
}
\description{
This function will add your Quick Stats API key to your
  \code{.Renviron} file so it can be called securely without being stored in
  your code. After you have installed your key, it can be called any time by
  typing \code{Sys.getenv("NASS_KEY")} and can be used in package functions
  by simply typing NASS_KEY. If you do not have an \code{.Renviron} file, the
  function will create on for you. If you already have an \code{.Renviron}
  file, the function will append the key to your existing file, while making
  a backup of your original file for disaster recovery purposes.
}
\examples{

\dontrun{
set_nass_key("abcd012345678901234567890123456789")
# First time, relead your enviornment so you can use the key without
# restarting R.
readRenviron("~/.Renviron")
# You can check it with:
Sys.getenv("NASS_KEY")
}

\dontrun{
# If you need to overwrite an existing key:
nass_set_key("abcd012345678901234567890123456789", overwrite = TRUE)
# First time, relead your enviornment so you can use the key without
# restarting R.
readRenviron("~/.Renviron")
# You can check it with:
Sys.getenv("NASS_KEY")
}
}
