% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pr.R
\name{pr.boot}
\alias{pr.boot}
\title{Bootstrap Confidence Intervals for Precision-Recall Curves}
\usage{
pr.boot(
  labels,
  preds,
  boot.n = 10000,
  boot.stratified = TRUE,
  alpha = 0.1,
  ...
)
}
\arguments{
\item{labels}{(\code{numeric()})\cr
Vector of responses/labels (only two classes/values allowed: cases/positive
class = 1 and controls/negative class = 0)}

\item{preds}{(\code{numeric()})\cr
Vector of prediction values. Higher values denote positive class.}

\item{boot.n}{(\code{numeric(1)})\cr
Number of bootstrap resamples. Default: 10000}

\item{boot.stratified}{(\code{logical(1)})\cr
Whether the bootstrap resampling is stratified (same number of cases/controls
in each replicate as in the original sample) or not.
It is advised to use stratified resampling when classes from \code{labels} are
imbalanced. Default: TRUE.}

\item{alpha}{(\code{numeric(1)})\cr
Confidence level for bootstrap percentile interval (between 0 and 1).
Default is 0.1, corresponding to 90\% confidence intervals.}

\item{...}{Other parameters to pass on to \link[precrec:evalmod]{precrec::evalmod}, except \code{mode}
(set to \code{rocpr}) and \code{raw_curves} (set to \code{TRUE}). For example \code{x_bins}
indicates the minimum number of recall points on the x-axis.}
}
\value{
A tibble with columns:
\itemize{
\item \code{recall}: recall of original data
\item \code{precision}: precision of original data
\item \code{low_precision}: low value of the bootstrap confidence interval
\item \code{high_precision}: high value of the bootstrap confidence interval
}
}
\description{
This functions calculates bootstrap percentile CIs for PR curves
using \CRANpkg{precrec}.
These can then be used in a plotting function, see example.
}
\examples{
set.seed(42)
# imbalanced labels
labels = sample(c(0,1), 100, replace = TRUE, prob = c(0.8,0.2))
# predictions
preds = rnorm(100)

# get CIs for PR curve
pr_tbl = pr.boot(labels, preds, boot.n = 100, x_bins = 30) # default x_bin is 1000
pr_tbl

# draw PR curve + add the bootstrap percentile confidence bands
library(ggplot2)

pr_tbl |>
  ggplot(aes(x = recall, y = precision)) +
  geom_step() +
  ylim(c(0,1)) +
  geom_ribbon(aes(ymin = precision_low, ymax = precision_high), alpha = 0.2)

}
\references{
Saito, Takaya, Rehmsmeier, Marc (2016).
\dQuote{Precrec: fast and accurate precision-recall and ROC curve calculations in R.}
\emph{Bioinformatics}, \bold{33}(1), 145--147.
\doi{10.1093/bioinformatics/btw570}.
}
