% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adjr2.R
\name{adjr2}
\alias{adjr2}
\title{adjr2}
\usage{
adjr2(o, p, k)
}
\arguments{
\item{o}{A numeric vector. Observed values.}

\item{p}{A numeric vector. Predicted values.}

\item{k}{A number. The number of parameters in the model. Note that k includes
the intercept, so for example, k is 2 for a linear regression model.}
}
\value{
Adjusted R2 (adjr2)
}
\description{
Calculates the Adjusted R2 (adjr2) from observed
values, predicted values and the number of model parameters.
}
\details{
Interpretation: larger is better. Adjusted R2 (adjr2) punishes complexity of models;
a larger number of parameters (k) means a smaller adjr2 value.
}
\examples{
obs<-c(1:10)
pred<-c(1, 1 ,3, 2, 4, 5, 6, 8, 7, 10)
adjr2(o=obs, p=pred, k=2)

}
\references{
Piikki K., Wetterlind J., Soderstrom M., Stenberg B. (2021). Perspectives
on validation in digital soil mapping of continuous attributes. A review.
Soil Use and Management. \doi{10.1111/sum.12694}
}
\author{
Kristin Piikki, Johanna Wetterlind, Mats Soderstrom and Bo Stenberg, 
E-mail: \email{kristin.piikki@slu.se}
}
