% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/allmetrics.R
\name{allmetrics}
\alias{allmetrics}
\title{allmetrics}
\usage{
allmetrics(o, p, k)
}
\arguments{
\item{o}{A numeric vector. Observed values.}

\item{p}{A numeric vector. Predicted values.}

\item{k}{A number. The number of parameters in the model. Note that k includes
the intercept, so for example, k is 2 for a linear regression model.}
}
\value{
A data.frame with all validation metrics for which functions are defined in 
this package.
}
\description{
Calculates 31 different validation metrics from observed
values and predicted values. For the calculation of some metrics also the 
number of model parameters are used.
}
\details{
See respective functions.
}
\examples{
obs<-c(1:10)
pred<-c(1, 1 ,3, 2, 4, 5, 6, 8, 7, 10)
allmetrics(o=obs, p=pred, k=2)
}
\references{
Piikki K., Wetterlind J., Soderstrom M., Stenberg B. (2021). Perspectives
on validation in digital soil mapping of continuous attributes. A review.
Soil Use and Management. \doi{10.1111/sum.12694}
}
\author{
Kristin Piikki, Johanna Wetterlind, Mats Soderstrom and Bo Stenberg, 
E-mail: \email{kristin.piikki@slu.se}
}
