% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lccc.R
\name{lccc}
\alias{lccc}
\title{lccc}
\usage{
lccc(o, p)
}
\arguments{
\item{o}{A numeric vector. Observed values.}

\item{p}{A numeric vector. Predicted values.}
}
\value{
Lin's concordance correlation coefficient (LCCC).
}
\description{
Calculates Lin's concordance correlation coefficient (LCCC) from observed and
predicted values.
}
\details{
Interpretation: Lin's concordance correlation coefficient (LCCC) can take values
between -1 and 1. LCCC-values close to 1 indicate a strong concordance between
predicted and observed values, while LCCC-values near -1 indicate a strong
discordance. LCCC-values close to 0 indicate no concordance. In a plot of
predicted values versus observed values, an LCCC-value of 1 means that the
all data points are on the 1.1-line.
}
\examples{
obs<-c(1:10)
pred<-c(1, 1 ,3, 2, 4, 5, 6, 8, 7, 10)
lccc(o=obs, p=pred)

}
\references{
Lawrence, I., & Lin, K. (1989). A concordance correlation
coefficient to evaluate reproducibility. Biometrics, 255-268.

Piikki K., Wetterlind J., Soderstrom M., Stenberg B. (2021). Perspectives
on validation in digital soil mapping of continuous attributes. A review.
Soil Use and Management. \doi{10.1111/sum.12694}
}
\author{
Kristin Piikki, Johanna Wetterlind, Mats Soderstrom and Bo Stenberg, 
E-mail: \email{kristin.piikki@slu.se}
}
