% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Step4_MonteCarloValuation.R
\name{valuatePortfolio}
\alias{valuatePortfolio}
\title{Valuate a Portfolio}
\usage{
valuatePortfolio(inPortfolio, mortTable, fundScen, dT = 1/12, df)
}
\arguments{
\item{inPortfolio}{A dataframe containing numPolicy rows and 45 attributes
of each VA policy.}

\item{mortTable}{A dataframe with three columns of doubles representing the
mortality table.}

\item{fundScen}{A numScen-by-numStep-by-numFund array of doubles of
return factors (i.e., exp(mu_t dt)) in each period.}

\item{dT}{A double of stepsize in years; dT = 1 / 12 would be monthly.}

\item{df}{A vector of doubles of risk-free discount rates of different tenor
(not forward rates), should have length being numStep.}
}
\value{
Outputs a list of doubles of portVal, the sum of average discounted
  payoff of the VAs in inPortfolio, portRC, the sum of average discounted
  risk charges of the VAs in inPortfolio, and vectors of doubles of these
  average discounted values for each policy.
}
\description{
Valuate a portfolio VA policies specified in each curPolicy of inPortfolio
based on the simulated fund scenarios fundScen.
The time step length is specified in dT and the discount rate for each period
is specified in df.
}
\examples{
fundScen <- genFundScen(fundMap, indexScen)[1, , ]
valuatePortfolio(VAPort[1:2, ], mortTable, fundScen, 1 / 12, cForwardCurve)
}
