% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vault_client_audit.R
\name{vault_client_audit}
\alias{vault_client_audit}
\title{Vault Audit Devices}
\description{
Vault Audit Devices

Vault Audit Devices
}
\details{
Interact with vault's audit devices.  For more details, see
https://developer.hashicorp.com/vault/docs/audit
}
\examples{
server <- vaultr::vault_test_server(if_disabled = message)
if (!is.null(server)) {
  client <- server$client()
  # By default no audit engines are enabled with the testing server
  client$audit$list()

  # Create a file-based audit device on a temporary file:
  path <- tempfile()
  client$audit$enable("file", options = list(file_path = path))
  client$audit$list()

  # Generate some activity on the server:
  client$write("/secret/mysecret", list(key = "value"))

  # The audit logs contain details about the activity - see the
  # vault documentation for details in interpreting this
  readLines(path)

  # cleanup
  server$kill()
  unlink(path)
}
}
\section{Super class}{
\code{\link[vaultr:vault_client_object]{vaultr::vault_client_object}} -> \code{vault_client_audit}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-vault_client_audit-new}{\code{vault_client_audit$new()}}
\item \href{#method-vault_client_audit-list}{\code{vault_client_audit$list()}}
\item \href{#method-vault_client_audit-enable}{\code{vault_client_audit$enable()}}
\item \href{#method-vault_client_audit-disable}{\code{vault_client_audit$disable()}}
\item \href{#method-vault_client_audit-hash}{\code{vault_client_audit$hash()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="vaultr" data-topic="vault_client_object" data-id="format"><a href='../../vaultr/html/vault_client_object.html#method-vault_client_object-format'><code>vaultr::vault_client_object$format()</code></a></span></li>
<li><span class="pkg-link" data-pkg="vaultr" data-topic="vault_client_object" data-id="help"><a href='../../vaultr/html/vault_client_object.html#method-vault_client_object-help'><code>vaultr::vault_client_object$help()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-vault_client_audit-new"></a>}}
\if{latex}{\out{\hypertarget{method-vault_client_audit-new}{}}}
\subsection{Method \code{new()}}{
Create an audit object
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{vault_client_audit$new(api_client)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{api_client}}{a \link{vault_api_client} object}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-vault_client_audit-list"></a>}}
\if{latex}{\out{\hypertarget{method-vault_client_audit-list}{}}}
\subsection{Method \code{list()}}{
List active audit devices.  Returns a \link{data.frame}
of names, paths and descriptions of active audit devices.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{vault_client_audit$list()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-vault_client_audit-enable"></a>}}
\if{latex}{\out{\hypertarget{method-vault_client_audit-enable}{}}}
\subsection{Method \code{enable()}}{
This endpoint enables a new audit device at the
supplied path.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{vault_client_audit$enable(
  type,
  description = NULL,
  options = NULL,
  path = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{type}}{Name of the audit device to enable}

\item{\code{description}}{Human readable description for this audit device}

\item{\code{options}}{Options to configure the device with.  These vary
by device. This must be a named list of strings.}

\item{\code{path}}{Path to mount the audit device.  By default, \code{type} is used
as the path.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-vault_client_audit-disable"></a>}}
\if{latex}{\out{\hypertarget{method-vault_client_audit-disable}{}}}
\subsection{Method \code{disable()}}{
Disable an audit device
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{vault_client_audit$disable(path)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{path}}{Path of the audit device to remove}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-vault_client_audit-hash"></a>}}
\if{latex}{\out{\hypertarget{method-vault_client_audit-hash}{}}}
\subsection{Method \code{hash()}}{
The \code{hash} method is used to calculate the hash of the
data used by an audit device's hash function and salt. This can be
used to search audit logs for a hashed value when the original
value is known.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{vault_client_audit$hash(input, device)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{input}}{The input string to hash}

\item{\code{device}}{The path of the audit device}
}
\if{html}{\out{</div>}}
}
}
}
