% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/meta_se.R
\name{se.oddsratio}
\alias{se.oddsratio}
\title{Computes the standard error for a log odds ratio}
\usage{
se.oddsratio(f1, n1, f2, n2)
}
\arguments{
\item{f1}{number of participants who have the outcome in group 1}

\item{n1}{sample size for group 1}

\item{f2}{number of participants who have the outcome in group 2}

\item{n2}{sample size for group 2}
}
\value{
Returns a one-row matrix:
\itemize{
\item Estimate - estimated log odds ratio
\item SE - standard error
}
}
\description{
Computes a log odds ratio and its standard error using
the frequency counts and sample sizes in a 2-group design. These
frequency counts and sample sizes can be obtained from a 2x2
contingency table. The log odd ratio and its standard error are computed
using a .5 addition to each frequency count of the 2x2 contingency table.
This function is useful in a meta-analysis of odds ratios where some studies
report the sample odds ratio and its standard error and other studies
only report the frequency counts for a 2x2 contingency table. The log odds
ratio and standard error output from this function can be used as input in
the \link[vcmeta]{meta.ave.gen.log} function.
}
\examples{
se.oddsratio(36, 50, 21, 50)

# Should return: 
#                  Estimate        SE
# Log odds ratio:  1.239501 0.4204435


}
\references{
\insertRef{Bonett2015}{vcmeta}
}
