% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/solid_cylindrical3d.R
\name{solid_cylindrical3d}
\alias{solid_cylindrical3d}
\title{Cylindrical solid defined by radial and vertical bounds (with optional plot)}
\usage{
solid_cylindrical3d(
  R1,
  R2,
  Z1,
  Z2,
  th_min,
  th_max,
  plot = TRUE,
  n_theta = 160,
  n_u = 70,
  n_v = 70,
  mode = c("faces", "wireframe", "both"),
  colorscale = "Blues",
  opacity = 0.35,
  show_surface_grid = TRUE,
  surface_grid_color = "rgba(60,80,200,0.25)",
  surface_grid_width = 1,
  edge_line = list(color = "black", width = 2),
  wire_line = list(color = "rgba(0,0,0,0.35)", width = 1),
  scene = list(aspectmode = "data", xaxis = list(title = "x"), yaxis = list(title = "y"),
    zaxis = list(title = "z")),
  bg = list(paper = "white", plot = "white"),
  compute_volume = FALSE,
  vol_method = c("adaptive", "grid"),
  ntheta_vol = 400,
  nr_vol = 400
)
}
\arguments{
\item{R1, R2}{Functions \code{function(theta)} giving the inner and outer
radius bounds, respectively.}

\item{Z1, Z2}{Functions \code{function(r, theta)} giving the lower and upper
\code{z} bounds.}

\item{th_min, th_max}{Angular limits (numeric scalars) with
\code{th_max > th_min}.}

\item{plot}{Logical. If \code{TRUE}, the solid is plotted using \pkg{plotly}.}

\item{n_theta, n_u, n_v}{Mesh resolution in \code{theta} (angle), \code{u}
(radial blend) and \code{v} (vertical blend).}

\item{mode}{Character string, one of \code{"faces"}, \code{"wireframe"} or
\code{"both"}, indicating whether to draw only the surface,
only a wireframe or both.}

\item{colorscale}{Plotly colorscale for the surface. It can be a named scale,
a single color, or a character vector of colors interpreted as a
gradient.}

\item{opacity}{Surface opacity, a numeric value between 0 and 1.}

\item{show_surface_grid}{Logical. If \code{TRUE}, draws a grid over the
surface.}

\item{surface_grid_color, surface_grid_width}{Color and line width used for
the surface grid.}

\item{edge_line, wire_line}{Line style lists used for the edges and the
wireframe lines when those are drawn.}

\item{scene, bg}{Plotly 3D scene configuration and background colors. The
background list typically has entries \code{paper} and \code{plot}.}

\item{compute_volume}{Logical. If \code{TRUE}, the volume of the solid is
approximated numerically.}

\item{vol_method}{Character string. Either \code{"adaptive"}, which uses
nested \code{stats::integrate}, or \code{"grid"}, which uses the
trapezoidal rule over a regular mesh.}

\item{ntheta_vol, nr_vol}{Mesh sizes in the angular and radial directions used
when \code{vol_method = "grid"}.}
}
\value{
A list with components:
\itemize{
\item \code{theta_seq}, \code{u_seq}, \code{v_seq}: the parameter sequences
used for sampling the surface,
\item \code{fig}: a \pkg{plotly} object when \code{plot = TRUE}, or
\code{NULL} otherwise,
\item \code{volume}: \code{NULL} if \code{compute_volume = FALSE}, or a
list containing the numeric volume estimate and metadata (method and
grid parameters) when \code{compute_volume = TRUE}.
}
}
\description{
Builds and optionally plots, using \pkg{plotly}, a three-dimensional solid
described in cylindrical coordinates. The solid is defined by:
\itemize{
\item an angular variable \code{theta} in the interval
\code{[th_min, th_max]},
\item a radial variable \code{r} between \code{R1(theta)} and
\code{R2(theta)},
\item and a vertical coordinate \code{z} between \code{Z1(r, theta)} and
\code{Z2(r, theta)}.
}

The surface is rendered by sampling a curvilinear grid in the parameters
\code{(theta, u, v)}, where \code{u} and \code{v} vary in \code{[0, 1]} and
are used as linear blending variables along the radial and vertical
directions, respectively.

When volume computation is requested, the function numerically approximates
the triple integral of the form
\code{integral theta from th_min to th_max} of
\code{integral r from R1(theta) to R2(theta)} of
\code{integral z from Z1(r, theta) to Z2(r, theta)} of
\code{r dz dr dtheta}, which is the standard volume element in cylindrical
coordinates.
}
\examples{
\donttest{
# Example: a quarter-twisted cup
# R in [0, 1 + 0.2*cos(theta)],  z in [0, 1 + 0.5*r]
R1 <- function(theta) 0
R2 <- function(theta) 1 + 0.2*cos(theta)
Z1 <- function(r, theta) 0
Z2 <- function(r, theta) 1 + 0.5*r
solid_cylindrical3d(
  R1, R2, Z1, Z2, th_min = 0, th_max = pi/2,
  plot = FALSE, mode = "both",
  colorscale = c("white", "#2a9d8f"), opacity = 0.35,
  show_surface_grid = TRUE,
  compute_volume = TRUE, vol_method = "adaptive"
)$volume
}

}
