% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/solid_of_revolution_y.R
\name{solid_of_revolution_y}
\alias{solid_of_revolution_y}
\title{Solid of revolution around a horizontal line}
\usage{
solid_of_revolution_y(
  f,
  xlim,
  a,
  nx = 120L,
  nt = 120L,
  deriv = NULL,
  h = NULL,
  include_end_caps = FALSE,
  plot = TRUE,
  colors = list(surface = "steelblue", axis = "black", curve = "firebrick"),
  opacity = 0.9,
  show_axis = TRUE,
  show_profile_curve = TRUE,
  curve_thetas = 0,
  curve_width = 4,
  curve_opacity = 1,
  scene = list(aspectmode = "data", xaxis = list(title = "x"), yaxis = list(title = "y"),
    zaxis = list(title = "z"))
)
}
\arguments{
\item{f}{Function of one numeric argument \code{x} that returns a numeric value.}

\item{xlim}{Numeric vector of length two with the limits of the x interval
\code{c(xmin, xmax)}, with \code{xmax > xmin}.}

\item{a}{Numeric scalar that gives the horizontal axis of rotation.}

\item{nx}{Integer number of grid points along the x direction (for plotting).}

\item{nt}{Integer number of grid points along the angular direction (for plotting).}

\item{deriv}{Optional function that returns the derivative of \code{f}. If \code{NULL}
a numeric derivative is used.}

\item{h}{Optional numeric step for the numeric derivative.}

\item{include_end_caps}{Logical value. If \code{TRUE} the area of the circular
cross sections at the ends of the interval is added to the total area.}

\item{plot}{Logical; if \code{TRUE} and \pkg{plotly} is available, the solid is drawn.}

\item{colors}{List with optional entries \code{surface}, \code{axis} and \code{curve} that
control the colours used in the plot.}

\item{opacity}{Numeric value between 0 and 1 that controls the surface
opacity in the plot.}

\item{show_axis}{Logical value indicating whether the axis of rotation
is drawn.}

\item{show_profile_curve}{Logical value indicating whether the generating
curve is drawn on the surface.}

\item{curve_thetas}{Numeric vector of angles (in radians) where profile curves are
drawn.}

\item{curve_width}{Numeric line width for the profile curves.}

\item{curve_opacity}{Numeric value between 0 and 1 for the profile curves.}

\item{scene}{List of \pkg{plotly} scene options used in \code{plotly::layout()}.}
}
\value{
A list with components:
\itemize{
\item \code{volume}: numeric value of the volume.
\item \code{surface_area_lateral}: numeric value of the lateral area.
\item \code{surface_area_total}: numeric value of the total area.
\item \code{figure}: \pkg{plotly} object with the three-dimensional plot
if \code{plot = TRUE} and \pkg{plotly} is available; otherwise \code{NULL}.
}
}
\description{
Construct a three-dimensional surface for the solid obtained by rotating
the graph of a function \code{f(x)} around the line \code{y = a} on a
finite interval, and compute its volume and surface areas.
}
\examples{
f <- function(x) sqrt(x)
solid_of_revolution_y(f, xlim = c(0, 4), a = 0, plot = FALSE)

}
