\name{vegetation_indices}
\alias{vegetation_indices}
\title{Calculate Different Vegetation Indices (VIs)}
\description{
The \code{vegetation_indices()} function supports the calculation of a wide range of vegetation indices (VIs) as listed below:
\itemize{
  \item \strong{Normalized Difference Vegetation Index (NDVI)}: Measures the health and vigor of vegetation.
  \item \strong{Green Normalized Difference Vegetation Index (GNDVI)}: Emphasizes chlorophyll content.
  \item \strong{Normalized Difference Infrared Index (NDII)}: Sensitive to soil moisture and vegetation stress.
  \item \strong{Enhanced Vegetation Index (EVI)}: Minimizes soil background noise and atmospheric effects.
  \item \strong{Soil-Adjusted Vegetation Index (SAVI)}: Accounts for soil background effects.
  \item \strong{Difference Vegetation Index (DVI)}: A simple measure of vegetation greenness.
  \item \strong{Green Difference Vegetation Index (GDVI)}: Emphasizes chlorophyll content.
  \item \strong{NIR Difference Index (NDI)}: A simple measure of vegetation greenness.
  \item \strong{Visible Atmospherically Resistant Vegetation Index (VARI)}: Minimizes atmospheric effects on vegetation measurements.
  \item \strong{Corrected Normalized Difference Vegetation Index (CNDVI)}: Similar to NDVI with a soil adjustment factor.
  \item \strong{Optimized Soil-Adjusted Vegetation Index (OSAVI)}: A refined version of SAVI with a specific soil adjustment factor.
  \item \strong{Chlorophyll Absorption Index (CAI)}: Directly related to chlorophyll concentration.
  \item \strong{Burn Area Index (BAI)}: The Burn Area Index (BAI) uses the reflectance values in the red and NIR portion of the spectrum to identify the areas of the terrain affected by fire.
  \item \strong{Chlorophyll Index - Green (CIg)}: The Chlorophyll Index - Green (CIg) method is a vegetation index for estimating the chlorophyll content in leaves using the ratio of reflectivity in the NIR and green bands.
  \item \strong{Global Environmental Monitoring Index (GEMI)}: The Global Environmental Monitoring Index (GEMI) method is a nonlinear vegetation index for global environmental monitoring from satellite imagery. It's similar to NDVI, but it's less sensitive to atmospheric effects. It is affected by bare soil; therefore, it's not recommended for use in areas of sparse or moderately dense vegetation.
  \item \strong{Modified Soil Adjusted Vegetation Index (MSAVI)}: Calculates the Modified Soil Adjusted Vegetation Index (MSAVI2) from a multiband raster object and returns a raster object with the index values.
\item \strong{Modified Triangular Vegetation Index (MTVI2)}: Calculates the Modified Triangular Vegetation Index (MTVI2) from a multiband raster object and returns a raster object with the index values.
\item \strong{Atmospherically Resistant Vegetation Index (ARVI)}: This is the first vegetation index, relatively insensitive to atmospheric factors (e.g., aerosols). Compared to other indices, ARVI is also more insensitive to relief effects, being particularly useful to monitor tropical mountainous regions often covered with soot due to slash-and-burn agriculture.
\item \strong{Structure Intensive Pigment Vegetation Index (SIPI)}: The SIPI vegetation index is good for the analysis of vegetation with the variable canopy structure. It estimates the ratio of carotenoids to chlorophyll: the increased value signals vegetation stress.
\item \strong{Normalized Burn Ratio (NBR)}: Used to highlight burned areas following the fire.  Healthy vegetation shows high reflectance in the NIR spectrum, whereas the recently burned areas of vegetation reflect highly in the SWIR spectrum.
\item \strong{Green Chlorophyll Vegetation Index (GCI)}: Used to estimate the content of leaf chlorophyll in various species of plants. The chlorophyll content reflects the physiological state of vegetation; it decreases in stressed plants and can therefore be used as a measurement of vegetation health
\item \strong{Red-Edge Chlorophyll Vegetation Index (RECI)}: Responsive to chlorophyll content in leaves that is nourished by nitrogen. ReCI shows the photosynthetic activity of the canopy cover.
}


\strong{Data Requirements:}
The input data must be a CSV file containing the following columns:
\itemize{
  \item \code{SERIAL_NO}: Serial number for observations.
  \item \code{RED}: Red reflectance.
  \item \code{GREEN}: Green reflectance.
  \item \code{NIR}: Near-infrared reflectance.
  \item \code{BLUE}: Blue reflectance.
  \item \code{L}: Soil adjustment factor.
  \item \code{SWIR2}: Shortwave infrared reflectance.
}
}
\usage{
vegetation_indices(data)
}
\arguments{
\item{data}{A CSV file containing the required columns specified in the Data Requirements section
}

}
\value{
The function returns a data frame with the following columns:
\itemize{
  \item \strong{Input columns:} \code{SERIAL_NO}, \code{RED}, \code{GREEN}, \code{NIR}, \code{BLUE}, \code{L}, \code{SWIR2}.
  \item \strong{Calculated Vegetation Indices (VIs):} \code{NDVI}, \code{GNDVI}, \code{NDII}, \code{EVI}, \code{SAVI}, \code{DVI}, \code{GDVI}, \code{NDI}, \code{VARI}, \code{CNDVI}, \code{OSAVI}, \code{CAI}, \code{BAI}, \code{CIg}, \code{GEMI}, \code{MSAVI}, \code{MTVI2}, \code{ARVI}, \code{SIPI}, \code{NBR}, \code{GCI}, \code{RECI}.
}
}

\references{
  Deb, D., Deb, S., Chakraborty, D., Singh, J.P., Singh, A.K., Dutta, P. and Choudhury, A., 2020. Aboveground biomass estimation of an agro-pastoral ecology in semi-arid Bundelkhand region of India from Landsat data: A comparison of support vector machine and traditional regression models. Geocarto International,  pp.1-14

  	Deb, D., J. P. Singh, S. Deb, D. Datta, A. Ghosh and R. S. Chaurasia, 2017, An alternative approach for estimating above ground biomass using Resourcesat-2 satellite data and artificial neural network in Bundelkhand region of India, Environmental Monitoring and Assessment, 189: 576

  Wang, F.M., Huang, J.F., Tang, Y.L. and Wang, X.Z., 2007. New vegetation index and its application in estimating leaf area index of rice. Rice Science, 14(3), pp.195-203.

  Wilson, N.R. and Norman, L.M., 2018. Analysis of vegetation recovery surrounding a restored wetland using the normalized difference infrared index (NDII) and normalized difference vegetation index (NDVI). International Journal of Remote Sensing, 39(10), pp.3243-3274.

  Mokarram, M., Hojjati, M., Roshan, G. and Negahban, S., 2015. Modeling the behavior of Vegetation Indices in the salt dome of Korsia in North-East of Darab, Fars, Iran. Modeling Earth Systems and Environment, 1, pp.1-9.

	Cao, J. and Yang, H., 2023. A dynamic normalized difference index for estimating soil organic matter concentration using visible and near-infrared spectroscopy. Ecological Indicators, 147, p.110037.

  Sharma, B., Ritchie, G.L. and Rajan, N., 2015. Near‐remote green: Red perpendicular vegetation index ground cover fraction estimation in cotton. Crop Science, 55(5), pp.2252-2261.
}


\examples{
# Sample data
sample_data <- data.frame(
  SERIAL_NO = 1:5,
  RED = c(0.13405, 0.134596, 0.141501, 0.143142, 0.147875),
  GREEN = c(0.091269, 0.090875, 0.106088, 0.098594, 0.099853),
  NIR = c(0.208945, 0.20439, 0.260778, 0.2183, 0.20648),
  BLUE = c(0.313418, 0.306585, 0.391168, 0.32745, 0.30972),
  L = c(0.133986, 0.125849, 0.091812, 0.130619, 0.109383),
  SWIR2 = c(28.07649, 26.57071, 26.1806, 25.61612, 24.4443)
)

# View the sample data
print(sample_data, row.names = FALSE)

# Calculate vegetation indices using the sample data
result <- vegetation_indices(sample_data)

# View the result
print(result, row.names = FALSE)
}
