% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cleanTaxonomy.R
\name{cleanTaxonomy}
\alias{cleanTaxonomy}
\title{Clean taxonomic names}
\usage{
cleanTaxonomy(Data, Taxonomy = "genus")
}
\arguments{
\item{Data}{A data frame of taxonomic ocurrences downloaded from the paleobiology database API.}

\item{Taxonomy}{A character string}
}
\value{
Will return a data frame identical to the original, but with the genus column cleaned.
}
\description{
Removes NAs and subgenera from the genus column.
}
\details{
Will remove NA's and subgenera from the genus column of a PBDB dataset. It can also be used on other datasets of similar structure to convert species names to genus, or remove NAs.
}
\examples{

# Download a test dataset of Cenozoic bivalves.
# DataPBDB<-downloadPBDB(Taxa="Bivalvia",StartInterval="Cenozoic",StopInterval="Cenozoic")

# Clean up the genus column.
# CleanedPBDB<-cleanTaxonomy(DataPBDB,"genus")

}
\author{
Andrew A. Zaffos
}
