% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/constrainAges.R
\name{constrainAges}
\alias{constrainAges}
\alias{constrainAges,multiplyAges}
\alias{multiplyAges}
\title{Constrain a dataset to only occurrences within a certain age-range}
\usage{
constrainAges(Data, Timescale)

multiplyAges(Data, Timescale)
}
\arguments{
\item{Data}{A data frame}

\item{Timescale}{A data frame}
}
\value{
A data frame
}
\description{
Assign fossil occurrences to different intervals within a geologic timescale, then remove occurrences that are not temporally constrained to a single interval within that timescale.
}
\details{
Cull a paleobiology database data frame to only occurrences temporally constrained to be within a certain level of the geologic timescale (e.g., period, epoch). The geologic timescale should come from the Macrostrat database, but custom time-scales can be used if structured in the same way. See \code{downloadTime} for how to download a timescale.
}
\examples{

# Download a test dataset of Cenozoic bivalves.
# DataPBDB<-downloadPBDB(Taxa="Bivalvia",StartInterval="Cenozoic",StopInterval="Cenozoic")

# Download the international epochs timescale from macrostrat.org
# Epochs<-downloadTime("international epochs")

# Find only occurrences that are temporally constrained to a single international epoch
# ConstrainedPBDB<-constrainAges(DataPBDB,Timescale=Epochs)

# Create mutliple instances of a single occurrence for each epoch it occurs in
# MultipliedPBDB<-multiplyAges(DataPBDB,Timescale=Epochs)

}
\author{
Andrew A. Zaffos
}
