% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/update-input.R
\name{updateNumericFilter}
\alias{updateNumericFilter}
\title{Change a numeric legend filter in the client}
\usage{
updateNumericFilter(
  session,
  inputId,
  label = NULL,
  start = NULL,
  end = NULL,
  minValue = NULL,
  maxValue = NULL
)
}
\arguments{
\item{session}{The \code{session} object passed to function given to
\code{shinyServer}.}

\item{inputId}{The id of the input object.}

\item{label}{The label to set for the input object.}

\item{start}{Beginning of selection interval.}

\item{end}{End of selection interval.}

\item{minValue}{Minimum numeric value in the legend (can be higher the maximum for inverted scale).}

\item{maxValue}{Maximum numeric value in the legend (can be lower the minimum for inverted scale).}
}
\description{
This function does not validate if a brush is already defined; updating only one of start or end with an empty brush will assign the other to NaN.
}
\details{
This function only affects the label and JavaScript-implemented axis and brush values and selection.
Re-creating the color strips and changing the ticks and format of values requires deleting and re-creating the legend using \code{shinyjs}, for example.
}
\seealso{
\code{\link[=continuousColorFilter]{continuousColorFilter()}} \code{\link[=discreteColorFilter]{discreteColorFilter()}}

Other update functions: 
\code{\link{updateCategoricalFilter}()}
}
\concept{update functions}
