% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fields_plot.R
\name{plotfield.normalized}
\alias{plotfield.normalized}
\title{Single plotting function for one 24-2 or 30-2 visual field measurement:}
\usage{
plotfield.normalized(eigenfields, component = 1,
  zmin = -max(abs(c(min(eigenfields), max(eigenfields)))),
  zmax = max(abs(c(min(eigenfields), max(eigenfields)))),
  color.pal = colorRampPalette(c("red", "white", "blue"), space =
  "Lab")(256), show.colorbar = TRUE, topleftannotation = NULL,
  bottomleftannotation = NULL, labelcex = 2, ...)
}
\arguments{
\item{eigenfields}{a vector contains Sensitivity/TD/PD measurement. For 24-2 VF \code{eigenfields} should have 52 or 54 elements. For 30-2 VF, \code{eigenfields} should have 74 or 76 elements.}

\item{component}{Number of components to be plotted (default: 1).}

\item{zmin}{minimum value of the color scale (default: auto defined).}

\item{zmax}{maximum value of the color scale (default: auto defined).}

\item{color.pal}{an object that defines color scale theme (default: colorRampPalette(c("red", "white", "blue"), space = "Lab")(256)).}

\item{show.colorbar}{a logic value to show colorbar (default: TRUE).}

\item{topleftannotation}{a string annotation shown on the top left side of the plot (default: NULL).}

\item{bottomleftannotation}{a string annotation shown on the bottom left side of the plot (default: NULL).}

\item{labelcex}{a numeric variable for label size (default: 2).}

\item{...}{other variables to be added.}
}
\value{
heatmap for sensitivity, TD and PD input
}
\description{
\code{plotfield.normalized} plots the following 24-2 or 30-2 visual field measurement: sensitivity, TD, TD prob, PD, and PD prob:
}
\examples{
data(vfseries)
eigenfields = t(vfseries[1, grepl('^s[0-9]+', colnames(vfseries))])
plotfield.normalized(eigenfields)
title(main = "Sensitivity", line = 3)
eigenfields = t(vfseries[1, grepl('^td[0-9]+', colnames(vfseries))])
plotfield.normalized(eigenfields)
title(main = "Total Deviation", line = 3)
eigenfields = t(vfseries[1, grepl('^pd[0-9]+', colnames(vfseries))])
plotfield.normalized(eigenfields)
title(main = "Pattern Deviation", line = 3)
}
