% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PR2.plot.R
\name{PR2.plot}
\alias{PR2.plot}
\title{Parity rule 2 (PR2) plot}
\usage{
PR2.plot(fasta.df)
}
\arguments{
\item{fasta.df}{a data frame with seq_name and its DNA sequence.}
}
\value{
A ggplot object.
}
\description{
Make a Parity rule 2 (PR2) plot, where the AT-bias [A3/(A3 +T3)] at the third codon position of the four-codon amino acids of entire genes is the ordinate and the GC-bias [G3/(G3 +C3)] is the abscissa. The center of the plot, where both coordinates are 0.5, is where A = U and G = C (PR2), with no bias between the influence of the mutation and selection rates.
}
\details{
For more information about PR2 plot \href{https://www.tandfonline.com/doi/full/10.1038/emi.2016.106}{Butt et al., 2016}.
}
\examples{
\dontshow{
file_path <- system.file("extdata", "sysdata.RData" ,package = "vhcub")
load(file = file_path)
}
\donttest{
# read DNA from fasta file
fasta <- fasta.read("virus.fasta", "host.fasta")
fasta.v <- fasta[[1]]
fasta.h <- fasta[[2]]
}

PR2.plot(fasta.v)

}
\author{
Ali Mostafa Anwar \email{ali.mo.anwar@std.agr.cu.edu.eg} and Mohmed Soudy \email{MohmedSoudy2009@gmail.com}
}
