% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_dose.R
\name{add_dose}
\alias{add_dose}
\title{Add drug dose column(s) to a dataset, in milligram per day}
\usage{
add_dose(
  .data,
  d_code,
  d_dose_names = names(d_code),
  repbasis = "sci",
  method = c("DrecNo", "MedicinalProd_Id"),
  drug_data,
  verbose = TRUE
)
}
\arguments{
\item{.data}{The dataset used to identify individual reports (usually, it is \code{demo})}

\item{d_code}{A named list of drug codes (DrecNos or MPI). See Details.}

\item{d_dose_names}{A character vector. Names for drug dose
columns (must be the same length as d_code), default to \code{names(d_code)}.
Will be followed by a fixed suffix "_dose_mg_per_day".}

\item{repbasis}{Suspect, interacting and/or concomitant.
Type initial of those you wish to select ("s" for suspect, "c" for concomitant
and "i" for interacting ; default to all, e.g. "sci").}

\item{method}{A character string.
The type of drug code (DrecNo or MedicinalProd_Id). See details.}

\item{drug_data}{A data.frame containing the drug data (usually, it is \code{drug})}

\item{verbose}{Logical, whether to display messages about added doses.}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}
\code{add_dose()} creates drug dose columns in vigibase
datasets (demo, link, adr, drug, ind)
for specified drugs in a dataset. It calculates daily dose values
based on dose amount, frequency, and their corresponding units.
The function is compatible with \code{demo}, \code{link}, \code{adr}, \code{drug} and \code{ind}
datasets.
}
\details{
Actual supported dosage regimens are any combination of:
\itemize{
\item Kilograms, grams, milligrams, micrograms, nanograms, or picograms
\item Per minute, hour, day, week, month, or year.
}
Note that the result will be expressed in \strong{milligrams per day}, whatever the
aforementioned combination is. This may lead to very small or very large amounts
in \code{drug_dose_mg_per_day} columns,
depending on the actual dosage regimen.
The function identifies drug doses in a dataset by cross-referencing
with a \code{drug_data} table.
If either the amount unit (grams, etc.) \emph{or} the frequency (days, etc.) is missing
in \code{drug_data}, the corresponding row will be omitted.
Drugs may be filtered based on reputation
bases (suspect, concomitant, or interacting).
Either drug record numbers (e.g., from \code{\link[=get_drecno]{get_drecno()}}), or
medicinalprod_ids (e.g., from \code{\link[=get_atc_code]{get_atc_code()}}) can be used to
identify drugs. Default method is to DrecNos.

\strong{It is very important to check the results}, as coding issues
are common for dose data, and some results may seem unreliable.
}
\examples{
# Example: Adding doses for paracetamol
d_code <- list(paracetamol = c(97818920, 97409107))
demo <-
  add_dose(
    .data = demo_,
    d_code = d_code,
    d_dose_names = "paracetamol",
    drug_data = drug_
    )

desc_cont(demo, "paracetamol_dose_mg_per_day")

# Use only drug dose where paracetamol had a "suspect" reputation base.
demo <-
  add_dose(
    .data = demo_,
    d_code = d_code,
    d_dose_names = "para_susp",
    repbasis = "s",
    drug_data = drug_
  )

desc_cont(demo, "para_susp_dose_mg_per_day")
}
\seealso{
\code{\link[=add_drug]{add_drug()}}, \code{\link[=get_drecno]{get_drecno()}}, \code{\link[=get_atc_code]{get_atc_code()}}
}
\keyword{data_management}
\keyword{doses}
\keyword{drug}
