% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HDdata.R
\docType{data}
\name{HDdata}
\alias{HDdata}
\title{Statlog (Heart) Data Set}
\format{
A data frame of 270 rows (patients) and 14 columns (variables):
}
\source{
\url{http://archive.ics.uci.edu/ml/datasets/statlog+(heart)}
}
\usage{
HDdata
}
\description{
The data consists of 270 patients described by six numerical 
variables and eight categorical variables.
}
\section{Fields}{

\describe{
\item{\code{age}}{Numerical. Age in years.}

\item{\code{resting_blood_pressure(trestbps)}}{Numerical. Resting blood pressure (in mmHg) at hospital admittance.}

\item{\code{maximum_heart_rate_achieved(maxhr).}}{Numerical. Maximum heart rate achieved during exercise.}

\item{\code{oldpeak}}{Numerical. ST depression induced by exercise relative to rest.}

\item{\code{number_of_major_vessels_colored_by_fluoroscopy(numv)}}{Numerical. Number of major vessels (0-3) colored by fluoroscopy.}

\item{\code{sex}}{Categorical. Sex (1 = male; 0 = female).}

\item{\code{chest_pain_type(cp)}}{Categorical. 1: typical angina, 2: atypical angina, 3: non-anginal pain, 4: asymptomatic.}

\item{\code{fasting_blood_sugar_>_120mg/dl(fbs)}}{Categorical. 1 = true; 0 = false.}

\item{\code{resting_electrocardiographic_results(restecg)}}{Categorical. 0: normal, 1: ST-T wave abnormality (T wave inversions and/or ST
elevation or depression >0.05mV), 2: showing probable or definite left ventricular hypertrophy by Estes' criteria.}

\item{\code{exercice_induced_angina(exang)}}{Categorical. 1 = yes; 0 = no.}

\item{\code{the_slope_of_the_peak_exercice_ST_segment(slope)}}{Categorical. 1: upsloping, 2: flat, 3: downsloping.}

\item{\code{thalassemia(thal)}}{Categorical. 3: normal blood flow, 6: fixed defect, 7: reversible defect.}

\item{\code{presence_or_absence_of_heart_disease(HD)}}{Categorical. Absence or presence of a heart disease.}
}}

\references{
A. Frank and A. Asuncion. UCI machine learning repository, statlog (heart) data set, 2010.
}
\keyword{datasets}
