% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/watercomp.R
\name{watercomp}
\alias{watercomp}
\title{Waterfall plot}
\usage{
watercomp(model, sep = "+", combination = NULL, z_value = FALSE, random = TRUE)
}
\arguments{
\item{model}{An object of class \code{\link[netmeta]{netmeta}}.}

\item{sep}{A single character that defines the separator between interventions components.}

\item{combination}{A single character that specifies the component combination of interest.}

\item{z_value}{\code{logical}. If \code{TRUE} z-values are used instead of interventions effects.}

\item{random}{\code{logical}. If \code{TRUE} z-values are obtained from the random-effects NMA model instead of the fixed-effect NMA model.}
}
\value{
An object of class \code{ggplot}.
}
\description{
The function produces a waterfall plot based on the z-values from the interventions that differ
by one specific component combination.
}
\details{
The function based on the intervention's z-values (default choice) obtained from the network meta-analysis (NMA) model
visualizes all the observed interventions that differ by one specific component
combination, in order to explore if the one extra component combination from every comparison
has a positive or negative impact. Bars above or below of the \eqn{y = 0} line,
indicates that the inclusion of the extra specific component combination has an impact on the
intervention. The direction of the impact (positive or negative), depends on the outcomes’ nature
(beneficial or harmful).

The combination of interest is defined from the argument \code{combination}. By default the
function visualizes the interventions that differ by one component (\code{combination = NULL}).
If for example \code{combination = "A+B"}, the function plots the interventions that differ
by "A+B".
}
\note{
In the case of dichotomous outcomes, the log-scale is used in axis y. Also, the function can be applied
only in network meta-analysis models that contain multi-component interventions.
}
\examples{
data(nmaMACE)
watercomp(nmaMACE)

}
