% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vis-binary.R
\name{vis_binary}
\alias{vis_binary}
\title{Visualise binary values}
\usage{
vis_binary(
  data,
  col_zero = "salmon",
  col_one = "steelblue2",
  col_na = "grey90",
  order = NULL
)
}
\arguments{
\item{data}{a data.frame}

\item{col_zero}{colour for zeroes, default is "salmon"}

\item{col_one}{colour for ones, default is "steelblue2"}

\item{col_na}{colour for NA, default is "grey90"}

\item{order}{optional character vector of the order of variables}
}
\value{
a ggplot plot of the binary values
}
\description{
Visualise binary values
}
\examples{
vis_binary(dat_bin)

# changing order of variables
# create numeric names
df <-  setNames(dat_bin, c("1.1", "8.9", "10.4"))
df

# not ideal
vis_binary(df)
# good - specify the original order
vis_binary(df, order = names(df))
}
