% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PEE.R
\name{PEE}
\alias{PEE}
\title{Penalized estimating equations for generalized linear models with multiple imputation}
\usage{
PEE(
  missdata,
  mice_time = 5,
  penalty,
  lamda.vec = seq(1, 4, length.out = 12),
  Gamma = c(0.5, 1, 1.5)
)
}
\arguments{
\item{missdata}{A Matrix,missing data with variables X in the first p columns and response Y at the last column.}

\item{mice_time}{an integer, number of imputation.}

\item{penalty}{The method for variable selection,choose from "lasso" or "alasso".}

\item{lamda.vec}{Optimal tuning parameter for penalty,default seq(1,4,length.out=12).}

\item{Gamma}{Parameter for adjustment of the Adaptive Weights vector in adaptive LASSO,default c(0.5,1,1.5).}
}
\value{
A Vsmi_est object, contians estcoef and index_sig , estcoef for estimate coefficients and index_sig for selected variable index.
}
\description{
This is a function to impute missing data, estimate coefficients of generalized linear models and select variables for multiple imputed data sets,
considering the correlation of multiple imputed observations.
}
\examples{
\donttest{
library(MASS)
library(mice)
library(qif)

data_with_missing <- generate_pee_missing_data(outcome="binary")
est.alasso <-PEE(data_with_missing,penalty="alasso")
est.lasso <-PEE(data_with_missing,penalty="lasso")

count_data_with_missing <- generate_pee_missing_data(outcome="count")
count_est.alasso <-PEE(data_with_missing,penalty="alasso")
count_est.lasso <-PEE(data_with_missing,penalty="lasso")
}
}
