% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generate_pwls_missing_data.R
\name{generate_pwls_missing_data}
\alias{generate_pwls_missing_data}
\title{Generate example data for PWLS}
\usage{
generate_pwls_missing_data(
  p = 20,
  n = 200,
  pt1 = 0.5,
  pt2 = 0.5,
  tbeta = c(1, -1, 1, -1, 1, -1, -1, 1),
  miss_sig = c(0, 1, 0, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0)
)
}
\arguments{
\item{p}{The dimension of the independent variable X,default 20.}

\item{n}{The Number of rows of generated data,default 200.}

\item{pt1}{Missing rate of independent variable X,default 0.5.}

\item{pt2}{Missing rate of response Y, default 0.5.}

\item{tbeta}{True value of the coefficient,default c(1,-1,1,-1,1,-1,-1,1).}

\item{miss_sig}{A 0-1 vector of length p, where 1 means that variable at the index is with missing,while 0 means that it without missing,defualt c(0,1,0,0,1,0,0,0,0,0,1,0,0,0,1,0,0,0,0,0)}
}
\value{
A Matrix,missing data with variables X in the first p columns and response Y at the last column.
}
\description{
This is a functoin to generate example missing data for PWLS
}
