% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vue.R
\name{vue3}
\alias{vue3}
\title{'Vue.js 3' 'htmlwidget'}
\usage{
vue3(
  app = list(),
  width = NULL,
  height = NULL,
  elementId = NULL,
  minified = TRUE
)
}
\arguments{
\item{app}{\code{list} with \code{el} and \code{data} and other pieces
of a 'Vue.js 3' app}

\item{width, height}{any valid \code{CSS} size unit, but in reality
this will not currently have any impact}

\item{elementId}{\code{character} id of the htmlwidget container
element}

\item{minified}{\code{logical} to indicate minified (\code{minified=TRUE}) or
non-minified (\code{minified=FALSE}) Vue.js}
}
\value{
vue htmlwidget
}
\description{
Use 'Vue.js 3' with the convenience and flexibility of 'htmlwidgets'.
\code{vue3} is a little different from other 'htmlwidgets' though
since it requires specification of the HTML tags/elements separately.
}
\examples{
if(interactive()) {

  library(vueR)
  library(htmltools)

  # recreate Hello Vue! example
  browsable(
    tagList(
      tags$div(id="app", "{{message}}"),
      vue3(
        list(
          el = "#app",
          # vue 3 is more burdensome but robust requiring data as function
          #   if data is not a function then widget will auto-convert
          data = list(message = "Hello Vue3!")
          # data = htmlwidgets::JS("
          #   function() {return {message: 'Hello Vue3!'}}
          # ")
        )
      )
    )
  )

  # app2 from Vue.js introduction
  browsable(
    tagList(
      tags$div(id="app-2",
        tags$span(
          "v-bind:title" = "message",
          "Hover your mouse over me for a few seconds to see my dynamically bound title!"
        )
      ),
      vue3(
        list(
          el = "#app-2",
          # vue 3 is more burdensome but robust requiring data as function
          #   if data is not a function then widget will auto-convert
          data = htmlwidgets::JS("
            function() {
              return {message: 'You loaded this page on ' + new Date()}
            }
          ")
        )
      )
    )
  )

  # app3 from Vue.js introduction
  #  with a setInterval to toggle seen true and false
  browsable(
    tagList(
      tags$div(id="app-3",
        tags$p("v-if"="seen", "Now you see me")
      ),
      vue3(
        list(
          el = '#app-3',
          data = list(seen = TRUE),
          # data = htmlwidgets::JS("function() {return {seen: true}}"),
          mounted = htmlwidgets::JS("
            function() {
              var that = this;
              setInterval(function(){that.seen=!that.seen},1000);
            }
          ")
        )
      )
    )
  )

}
}
\seealso{
Other htmlwidget: 
\code{\link{vue}()}
}
\concept{htmlwidget}
