% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{rect}
\alias{rect}
\alias{inv_rect}
\title{Rectangular transformation}
\usage{
rect(z, a, b)

inv_rect(x, a, b)
}
\arguments{
\item{z}{A point in the rectangle \eqn{[a_1,b_1] \times \cdots \times [a_d,b_d]}.}

\item{a}{A vector \eqn{(a_1, \ldots, a_d)}, Elements may be \code{-Inf}.}

\item{b}{A vector \eqn{(b_1, \ldots, b_d)}, Elements may be \code{+Inf}.}

\item{x}{A point in \eqn{\mathbb{R}^{d}}.}
}
\value{
A vector of length \eqn{d}.
}
\description{
A transformation from unconstrained \eqn{\mathbb{R}^d} to a rectangle in
\eqn{\mathbb{R}^d}, and its inverse transformation.
}
\examples{
n = 20
x = seq(-5, 5, length.out = n)

# Transform x to the interval [-1, 1]
a = rep(-1, n)
b = rep(+1, n)
z = inv_rect(x, a, b)
print(z)
xx = rect(z, a, b)
stopifnot(all(abs(x - xx) < 1e-8))

# Transform x to the interval [-Inf, 1]
a = rep(-Inf, n)
b = rep(+1, n)
z = inv_rect(x, a, b)
print(z)
xx = rect(z, a, b)
stopifnot(all(abs(x - xx) < 1e-8))

# Transform x to the interval [-1, Inf]
a = rep(-1, n)
b = rep(+Inf, n)
z = inv_rect(x, a, b)
print(z)
xx = rect(z, a, b)
stopifnot(all(abs(x - xx) < 1e-8))

# Transform x to the interval [-Inf, Inf]
a = rep(-Inf, n)
b = rep(+Inf, n)
z = inv_rect(x, a, b)
print(z)
xx = rect(z, a, b)
stopifnot(all(abs(x - xx) < 1e-8))

}
